/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.addon;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.json.JsonValue;

public class AddonLocalData {
    private final File file;
    private final String name;
    private final List<String> authors;
    private final int supportedBuild;
    private final String version;
    private final List<String> description = Lists.newArrayList();
    private final List<String> classChecks = Lists.newArrayList();
    private final List<SupportData> pluginSupport = Lists.newArrayList();

    public AddonLocalData(File file, JsonObject json) {
        JsonValue value;
        this.file = file;
        this.name = json.getString("name", "UNKNOWN");
        this.authors = new ArrayList<String>();
        if (json.names().contains("author")) {
            this.authors.add(json.getString("author", "UNKNOWN"));
        } else if (json.names().contains("authors")) {
            ((JsonArray)json.get("authors")).forEach(jsonValue -> this.authors.add(jsonValue.asString()));
        }
        this.version = String.valueOf(json.getDouble("version", 0.0));
        this.supportedBuild = json.getInt("supported-build", -1);
        if (json.names().contains("description")) {
            value = json.get("description");
            if (value instanceof JsonArray) {
                ((JsonArray)value).forEach(jsonValue -> this.description.add(jsonValue.asString()));
            } else {
                this.description.add(value.asString());
            }
        }
        if (json.names().contains("class-checks")) {
            value = json.get("class-checks");
            if (value instanceof JsonArray) {
                ((JsonArray)value).forEach(jsonValue -> this.classChecks.add(jsonValue.asString()));
            } else {
                this.classChecks.add(value.asString());
            }
        }
        if (json.names().contains("plugin-support")) {
            value = (JsonArray)json.get("plugin-support");
            value.forEach(jsonValue -> {
                JsonObject object = (JsonObject)jsonValue;
                this.pluginSupport.add(new SupportData(object.getString("name", "Unknown"), object.getString("url", "Unknown")));
            });
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getSupportedBuild() {
        return this.supportedBuild;
    }

    public List<String> getClassChecks() {
        return this.classChecks;
    }

    public List<SupportData> getPluginSupport() {
        return this.pluginSupport;
    }

    public static final class SupportData {
        private final String name;
        private final String url;

        public SupportData(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String name() {
            return this.name;
        }

        public String url() {
            return this.url;
        }
    }
}

