/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntityZombiePet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_8.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

public class EntityZombiePet
extends EntityPetOverride
implements IEntityZombiePet {
    private static final DataWatcherObject<Boolean> BABY = DataWatcher.a(EntityZombiePet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> UNKNOWN = DataWatcher.a(EntityZombiePet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> DROWN_CONVERTING = DataWatcher.a(EntityZombiePet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityZombiePet(PetType type, PetUser user) {
        this((EntityTypes<? extends EntityInsentient>)EntityTypes.bQ, type, user);
    }

    public EntityZombiePet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("raised-arms", this.isArmsRaised());
        data.add("baby", this.isBabySafe());
        data.add("shaking", this.isShaking());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(BABY, false);
        dataAccess.define(UNKNOWN, 0);
        dataAccess.define(DROWN_CONVERTING, false);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("raised_arms", this.isArmsRaised());
        object.setBoolean("baby", this.isBabySafe());
        object.setBoolean("shaking", this.isShaking());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        this.setArmsRaised(object.getBoolean("raised_arms", false));
        this.setBabySafe(object.getBoolean("baby", false));
        this.setShaking(object.getBoolean("shaking", false));
        super.applyCompound(object);
    }

    @Override
    public void setArmsRaised(boolean flag) {
        super.w(flag);
    }

    @Override
    public boolean isArmsRaised() {
        return super.gy();
    }

    @Override
    public boolean isShaking() {
        return (Boolean)this.ay.a(DROWN_CONVERTING);
    }

    @Override
    public void setShaking(boolean shaking) {
        this.ay.a(DROWN_CONVERTING, (Object)shaking);
    }

    @Override
    public boolean isBabySafe() {
        return (Boolean)this.ay.a(BABY);
    }

    @Override
    public void setBabySafe(boolean flag) {
        this.ay.a(BABY, (Object)flag);
    }
}

