/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntityTropicalFishPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.TropicalPattern;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.utils.DyeColorWrapper;
import simplepets.brainsynder.versions.v1_21_8.entity.EntityFishPet;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

public class EntityTropicalFishPet
extends EntityFishPet
implements IEntityTropicalFishPet {
    private static final DataWatcherObject<Integer> VARIANT = DataWatcher.a(EntityTropicalFishPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);

    public EntityTropicalFishPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bC, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("body", this.getBodyColor().name());
        data.add("pattern", this.getPattern().name());
        data.add("color", this.getPatternColor().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(VARIANT, 0);
    }

    @Override
    public DyeColorWrapper getPatternColor() {
        return this.getRawPatternColor((Integer)this.ay.a(VARIANT));
    }

    @Override
    public void setPatternColor(DyeColorWrapper color) {
        this.ay.a(VARIANT, (Object)this.getRawData(color, this.getBodyColor(), this.getPattern()));
    }

    @Override
    public DyeColorWrapper getBodyColor() {
        return this.getRawBodyColor((Integer)this.ay.a(VARIANT));
    }

    @Override
    public void setBodyColor(DyeColorWrapper color) {
        this.ay.a(VARIANT, (Object)this.getRawData(this.getPatternColor(), color, this.getPattern()));
    }

    @Override
    public TropicalPattern getPattern() {
        return this.getRawPattern((Integer)this.ay.a(VARIANT));
    }

    @Override
    public void setPattern(TropicalPattern pattern) {
        this.ay.a(VARIANT, (Object)this.getRawData(this.getPatternColor(), this.getBodyColor(), pattern));
    }

    private DyeColorWrapper getRawPatternColor(int data) {
        return DyeColorWrapper.getByWoolData((byte)(data >> 24 & 0xFF));
    }

    private DyeColorWrapper getRawBodyColor(int data) {
        return DyeColorWrapper.getByWoolData((byte)(data >> 16 & 0xFF));
    }

    private TropicalPattern getRawPattern(int data) {
        return TropicalPattern.fromData(data & 0xFFFF);
    }

    private int getRawData(DyeColorWrapper patternColor, DyeColorWrapper bodyColor, TropicalPattern type) {
        return patternColor.getWoolData() << 24 | bodyColor.getWoolData() << 16 | type.getDataValue();
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setString("body", this.getBodyColor().name());
        compound.setString("pattern", this.getPattern().name());
        compound.setString("color", this.getPatternColor().name());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound compound) {
        super.applyCompound(compound);
        if (compound.hasKey("body")) {
            this.setBodyColor(DyeColorWrapper.getByName(compound.getString("body")));
        }
        if (compound.hasKey("pattern")) {
            this.setPattern(TropicalPattern.getByName(compound.getString("pattern")));
        }
        if (compound.hasKey("color")) {
            this.setPatternColor(DyeColorWrapper.getByName(compound.getString("color")));
        }
    }
}

