/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.list;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarpet;
import org.bukkit.NamespacedKey;
import simplepets.brainsynder.api.entity.passive.IEntityLlamaPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.ColorWrapper;
import simplepets.brainsynder.api.wrappers.LlamaColor;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_8.entity.branch.EntityDonkeyAbstractPet;
import simplepets.brainsynder.versions.v1_21_8.helper.VersionHelper;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

public class EntityLlamaPet
extends EntityDonkeyAbstractPet
implements IEntityLlamaPet {
    private static final DataWatcherObject<Integer> STRENGTH = DataWatcher.a(EntityLlamaPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> VARIANT = DataWatcher.a(EntityLlamaPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);

    public EntityLlamaPet(PetType type, PetUser user) {
        this((EntityTypes<? extends EntityInsentient>)EntityTypes.az, type, user);
    }

    public EntityLlamaPet(EntityTypes<? extends EntityInsentient> llama, PetType type, PetUser user) {
        super(llama, type, user);
        this.doIndirectAttach = false;
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("skin", this.getSkinColor().name());
        data.add("color", this.getColorWrapper().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(STRENGTH, 0);
        dataAccess.define(VARIANT, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setString("skin", this.getSkinColor().name());
        object.setString("color", this.getColorWrapper().name());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("skin")) {
            this.setSkinColor(LlamaColor.getByName(object.getString("skin")));
        }
        if (object.hasKey("color")) {
            this.setColorWrapper(ColorWrapper.getByName(object.getString("color")));
        }
        super.applyCompound(object);
    }

    @Override
    public void setSkinColor(LlamaColor skinColor) {
        this.ay.a(VARIANT, (Object)skinColor.ordinal());
    }

    @Override
    public LlamaColor getSkinColor() {
        return LlamaColor.getByID((Integer)this.ay.a(VARIANT));
    }

    @Override
    public ColorWrapper getColorWrapper() {
        EnumColor dyeColor = this.getDyeColor(this.a(EnumItemSlot.g));
        byte data = dyeColor == null ? (byte)-1 : (byte)dyeColor.a();
        ColorWrapper color = ColorWrapper.getByWoolData(data);
        if (color == null) {
            color = ColorWrapper.getByDyeData(data);
        }
        return color;
    }

    @Override
    public void setColorWrapper(ColorWrapper color) {
        if (color == ColorWrapper.NONE) {
            this.setItemSlot(EnumItemSlot.g, ItemStack.l, true);
            return;
        }
        EnumColor dyeColor = EnumColor.a((int)color.getWoolData());
        Item item = (Item)VersionHelper.getRegistryValue(BuiltInRegistries.g, NamespacedKey.minecraft((String)(dyeColor.b() + "_carpet")));
        this.a(EnumItemSlot.g, new ItemStack((IMaterial)item));
    }

    private EnumColor getDyeColor(ItemStack itemstack) {
        Block block = Block.a((Item)itemstack.h());
        return block instanceof BlockCarpet ? ((BlockCarpet)block).b() : null;
    }
}

