/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Items;
import simplepets.brainsynder.api.entity.passive.IEntityHappyGhastPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.ColorWrapper;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_8.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

@SupportedVersion(version=ServerVersion.v1_21_6)
public class EntityHappyGhastPet
extends EntityAgeablePet
implements IEntityHappyGhastPet {
    private static final DataWatcherObject<Boolean> IS_LEASH_HOLDER = DataWatcher.a(EntityHappyGhastPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> STAYS_STILL = DataWatcher.a(EntityHappyGhastPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private ColorWrapper color = ColorWrapper.NONE;

    public EntityHappyGhastPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.af, type, user);
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(IS_LEASH_HOLDER, false);
        dataAccess.define(STAYS_STILL, false);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("color", this.getColorWrapper().name());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setEnum("color", this.getColorWrapper());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("color")) {
            this.setColorWrapper(object.getEnum("color", ColorWrapper.class, ColorWrapper.NONE));
        }
        super.applyCompound(object);
    }

    @Override
    public ColorWrapper getColorWrapper() {
        return this.color;
    }

    @Override
    public void setColorWrapper(ColorWrapper color) {
        this.color = color;
        switch (color) {
            case NONE: {
                this.a(EnumItemSlot.g, Items.a.m());
                break;
            }
            case WHITE: {
                this.a(EnumItemSlot.g, Items.ow.m());
                break;
            }
            case ORANGE: {
                this.a(EnumItemSlot.g, Items.ox.m());
                break;
            }
            case MAGENTA: {
                this.a(EnumItemSlot.g, Items.oy.m());
                break;
            }
            case LIGHT_BLUE: {
                this.a(EnumItemSlot.g, Items.oz.m());
                break;
            }
            case YELLOW: {
                this.a(EnumItemSlot.g, Items.oA.m());
                break;
            }
            case LIME: {
                this.a(EnumItemSlot.g, Items.oB.m());
                break;
            }
            case PINK: {
                this.a(EnumItemSlot.g, Items.oC.m());
                break;
            }
            case GRAY: {
                this.a(EnumItemSlot.g, Items.oD.m());
                break;
            }
            case LIGHT_GRAY: {
                this.a(EnumItemSlot.g, Items.oE.m());
                break;
            }
            case CYAN: {
                this.a(EnumItemSlot.g, Items.oF.m());
                break;
            }
            case PURPLE: {
                this.a(EnumItemSlot.g, Items.oG.m());
                break;
            }
            case BLUE: {
                this.a(EnumItemSlot.g, Items.oH.m());
                break;
            }
            case BROWN: {
                this.a(EnumItemSlot.g, Items.oI.m());
                break;
            }
            case GREEN: {
                this.a(EnumItemSlot.g, Items.oJ.m());
                break;
            }
            case RED: {
                this.a(EnumItemSlot.g, Items.oK.m());
                break;
            }
            case BLACK: {
                this.a(EnumItemSlot.g, Items.oL.m());
            }
        }
    }
}

