/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.branch;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.misc.IShaking;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_8.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

public abstract class EntityPiglinAbstractPet
extends EntityPetOverride
implements IShaking {
    private static final DataWatcherObject<Boolean> IMMUNE_TO_ZOMBIFICATION = DataWatcher.a(EntityPiglinAbstractPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityPiglinAbstractPet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("shaking", this.isShaking());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(IMMUNE_TO_ZOMBIFICATION, true);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("shaking", this.isShaking());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("shaking")) {
            this.setShaking(object.getBoolean("shaking"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isShaking() {
        return (Boolean)this.ay.a(IMMUNE_TO_ZOMBIFICATION);
    }

    @Override
    public void setShaking(boolean shaking) {
        this.ay.a(IMMUNE_TO_ZOMBIFICATION, (Object)(!shaking ? 1 : 0));
    }
}

