/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.entity.hostile.IEntityWardenPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.AngerLevel;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

@SupportedVersion(version=ServerVersion.v1_19)
public class EntityWardenPet
extends EntityPetOverride
implements IEntityWardenPet {
    protected static final DataWatcherObject<Integer> ANGER_LEVEL = DataWatcher.a(EntityWardenPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private boolean vibrationEffect = false;
    private int vibrationTick = 0;

    public EntityWardenPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bI, type, user);
        if (ConfigOption.INSTANCE.PET_TOGGLES_WARDEN_ANIMATIONS.getValue().booleanValue()) {
            this.b(EntityPose.n);
            Bukkit.getScheduler().runTaskLater((Plugin)PetCore.getInstance(), () -> this.b(EntityPose.a), 135L);
        }
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("anger", this.getAngerLevel().name());
        data.add("raw-anger", (Integer)this.ay.a(ANGER_LEVEL));
        data.add("vibration-effect", this.getVibrationEffect());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(ANGER_LEVEL, 0);
    }

    @Override
    public void g() {
        super.g();
        if (this.vibrationEffect) {
            if (this.vibrationTick <= 0) {
                this.ai().a((Entity)this, (byte)61);
                this.a(SoundEffects.DC, 5.0f, this.fl());
                this.vibrationTick = MathUtils.random(40, 60);
            }
            --this.vibrationTick;
        }
    }

    @Override
    public void setAngerLevel(AngerLevel level) {
        int anger = 10;
        if (level == AngerLevel.AGITATED) {
            anger = 50;
        }
        if (level == AngerLevel.ANGRY) {
            anger = 90;
        }
        this.ay.a(ANGER_LEVEL, (Object)anger);
    }

    @Override
    public AngerLevel getAngerLevel() {
        int anger = (Integer)this.ay.a(ANGER_LEVEL);
        if (anger >= 80) {
            return AngerLevel.ANGRY;
        }
        if (anger <= 39) {
            return AngerLevel.CALM;
        }
        return AngerLevel.AGITATED;
    }

    @Override
    public void setVibrationEffect(boolean value) {
        this.vibrationEffect = value;
        if (!value) {
            this.vibrationTick = 0;
        }
    }

    @Override
    public boolean getVibrationEffect() {
        return this.vibrationEffect;
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setInteger("raw-anger", (Integer)this.ay.a(ANGER_LEVEL));
        object.setEnum("anger-level", this.getAngerLevel());
        object.setBoolean("vibration", this.vibrationEffect);
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("raw-anger")) {
            this.ay.a(ANGER_LEVEL, (Object)object.getInteger("raw-anger"));
        }
        if (object.hasKey("anger-level")) {
            this.setAngerLevel(object.getEnum("anger-level", AngerLevel.class, AngerLevel.CALM));
        }
        if (object.hasKey("vibration")) {
            this.setVibrationEffect(object.getBoolean("vibration"));
        }
        super.applyCompound(object);
    }

    @Override
    public void k(Vec3D vec3d) {
        if (this.aw() != EntityPose.a) {
            return;
        }
        super.k(vec3d);
    }

    public void a(Entity.RemovalReason entity_removalreason) {
        if (!ConfigOption.INSTANCE.PET_TOGGLES_WARDEN_ANIMATIONS.getValue().booleanValue()) {
            super.a(entity_removalreason);
            return;
        }
        this.b(EntityPose.o);
        Bukkit.getScheduler().runTaskLater((Plugin)PetCore.getInstance(), () -> super.a(entity_removalreason), 100L);
    }
}

