/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntitySnowmanPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

public class EntitySnowmanPet
extends EntityPetOverride
implements IEntitySnowmanPet {
    private static final DataWatcherObject<Byte> PUMPKIN = DataWatcher.a(EntitySnowmanPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);

    public EntitySnowmanPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bn, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("pumpkin", this.hasPumpkin());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(PUMPKIN, (byte)0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("pumpkin", this.hasPumpkin());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("pumpkin")) {
            this.setHasPumpkin(object.getBoolean("pumpkin"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean hasPumpkin() {
        return ((Byte)this.ay.a(PUMPKIN) & 0x10) != 0;
    }

    @Override
    public void setHasPumpkin(boolean flag) {
        byte b0 = (Byte)this.ay.a(PUMPKIN);
        if (flag) {
            this.ay.a(PUMPKIN, (Object)((byte)(b0 | 0x10)));
        } else {
            this.ay.a(PUMPKIN, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }
}

