/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import simplepets.brainsynder.api.entity.passive.IEntityParrotPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.ParrotVariant;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityTameablePet;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

public class EntityParrotPet
extends EntityTameablePet
implements IEntityParrotPet {
    private static final DataWatcherObject<Integer> TYPE = DataWatcher.a(EntityParrotPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private boolean rainbow = false;
    private int toggle = 0;

    public EntityParrotPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.aQ, type, user);
        this.ce = new ControllerMoveFlying((EntityInsentient)this, 10, false);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("variant", this.getVariant().name());
        data.add("rainbow", this.isRainbow());
    }

    protected NavigationAbstract b(World level) {
        NavigationFlying navigation = new NavigationFlying((EntityInsentient)this, level);
        navigation.d(false);
        navigation.a(false);
        return navigation;
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(TYPE, 0);
    }

    @Override
    public void g() {
        super.g();
        if (this.rainbow) {
            if (this.toggle == 4) {
                this.setVariant(ParrotVariant.getNext(this.getVariant()));
                this.getPetUser().updateDataMenu();
                this.toggle = 0;
            }
            ++this.toggle;
        }
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("variant")) {
            this.setVariant(ParrotVariant.getByName(object.getString("variant")));
        }
        if (object.hasKey("rainbow")) {
            this.rainbow = object.getBoolean("rainbow");
        }
        super.applyCompound(object);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        if (!this.rainbow) {
            object.setString("variant", this.getVariant().name());
        }
        object.setBoolean("rainbow", this.rainbow);
        return object;
    }

    @Override
    public ParrotVariant getVariant() {
        return ParrotVariant.getById((Integer)this.ay.a(TYPE));
    }

    @Override
    public void setVariant(ParrotVariant variant) {
        this.ay.a(TYPE, (Object)variant.ordinal());
    }

    @Override
    public boolean isRainbow() {
        return this.rainbow;
    }

    @Override
    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    @Override
    public void k(Vec3D vec3) {
        if (this.isOwnerRiding()) {
            super.k(vec3);
            this.s(false);
            return;
        }
        if (this.bm()) {
            this.a(0.02f, vec3);
            this.a(EnumMoveType.a, this.dA());
            this.i(this.dA().c((double)0.8f));
        } else if (this.bA()) {
            this.a(0.02f, vec3);
            this.a(EnumMoveType.a, this.dA());
            this.i(this.dA().c(0.5));
        } else {
            this.a(this.fu(), vec3);
            this.a(EnumMoveType.a, this.dA());
            this.i(this.dA().c(0.8100000262260437));
        }
        this.s(false);
    }
}

