/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.branch;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.misc.IEntityWizard;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.WizardSpell;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.sounds.SoundMaker;
import simplepets.brainsynder.versions.v1_21_7.entity.branch.EntityIllagerAbstractPet;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

public class EntityIllagerWizardPet
extends EntityIllagerAbstractPet
implements IEntityWizard {
    private static final DataWatcherObject<Byte> SPELL = DataWatcher.a(EntityIllagerWizardPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);

    public EntityIllagerWizardPet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("spell", this.getSpell().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(SPELL, (byte)0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("spell", this.getSpell());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("spell")) {
            this.setSpell(object.getEnum("spell", WizardSpell.class, WizardSpell.NONE));
        }
        super.applyCompound(object);
    }

    @Override
    public WizardSpell getSpell() {
        return WizardSpell.fromID(((Byte)this.ay.a(SPELL)).byteValue());
    }

    @Override
    public void setSpell(WizardSpell spell) {
        this.ay.a(SPELL, (Object)((byte)spell.getId()));
        if (spell == WizardSpell.WOLOLO) {
            SoundMaker.ENTITY_EVOCATION_ILLAGER_PREPARE_WOLOLO.playSound(this.getEntity());
        } else {
            SoundMaker.ENTITY_EVOCATION_ILLAGER_CAST_SPELL.playSound(this.getEntity());
        }
    }

    @Override
    public void g() {
        super.g();
        if ((Byte)this.ay.a(SPELL) > 0) {
            WizardSpell spell = this.getSpell();
            double velocityX = spell.getArray()[0];
            double velocityY = spell.getArray()[1];
            double velocityZ = spell.getArray()[2];
            float value = this.br * ((float)Math.PI / 180) + MathHelper.cos((double)((float)this.as * 0.6662f)) * 0.25f;
            float offsetX = MathHelper.cos((double)value);
            float f = MathHelper.sin((double)value);
        }
    }
}

