/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.entity.misc.IFlyableEntity;
import simplepets.brainsynder.api.event.entity.EntityNameChangeEvent;
import simplepets.brainsynder.api.event.entity.PetMoveEvent;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.sounds.SoundMaker;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityBase;
import simplepets.brainsynder.versions.v1_21_7.entity.SeatEntity;
import simplepets.brainsynder.versions.v1_21_7.helper.VersionHelper;
import simplepets.brainsynder.versions.v1_21_7.pathfinder.LegacyPathfinderFollowPlayer;
import simplepets.brainsynder.versions.v1_21_7.pathfinder.PathfinderFollowPlayer;
import simplepets.brainsynder.versions.v1_21_7.pathfinder.PathfinderGoalLookAtOwner;
import simplepets.brainsynder.versions.v1_21_7.utils.EntityUtils;

public abstract class EntityPet
extends EntityBase
implements IEntityPet {
    private Map<String, StorageTagCompound> additional;
    private String petName = null;
    private final EntityTypes<? extends EntityInsentient> rawEntityType;
    private final double jumpHeight = 0.5;
    private boolean isGlowing = false;
    private boolean frozen = false;
    private boolean onFire = false;
    private boolean silent = false;
    private boolean visible = true;
    private ChatColor glowColor = ChatColor.WHITE;
    private boolean ignoreVanish = false;
    private int standStillTicks = 0;
    private int hoverTickCount = 0;
    private int blockX = 0;
    private int blockZ = 0;
    private int blockY = 0;
    protected boolean doIndirectAttach;
    protected double walkSpeed = 0.6f;
    protected double rideSpeed = 0.4000000238418579;
    protected double flySpeed = 0.1f;
    private boolean floatDown = false;
    private boolean glowVanishToggle = true;
    private boolean autoRemoveToggle = true;
    private boolean displayNameVisibility = true;
    private boolean hideNameShifting = true;
    private int autoRemoveTick = 10000;
    private final int hoverRemoveTick = 6000;
    private boolean verticalWorldConfines = false;
    private int maxHeight;
    private int minHeight;

    public EntityPet(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super(entitytypes, world);
        this.rawEntityType = EntityTypes.aS;
    }

    public EntityPet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
        this.rawEntityType = entitytypes;
        this.additional = new HashMap<String, StorageTagCompound>();
        this.collides = false;
        this.aq = false;
        VersionHelper.overrideAttributeMap(this);
        this.glowVanishToggle = ConfigOption.INSTANCE.PET_TOGGLES_GLOW_VANISH.getValue();
        this.autoRemoveToggle = ConfigOption.INSTANCE.AUTO_REMOVE_ENABLED.getValue();
        this.autoRemoveTick = ConfigOption.INSTANCE.AUTO_REMOVE_TICK.getValue();
        this.hideNameShifting = ConfigOption.INSTANCE.PET_TOGGLES_SHIFT_HIDDEN_NAMES.getValue();
        this.displayNameVisibility = ConfigOption.INSTANCE.PET_TOGGLES_SHOW_NAMES.getValue();
        SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(config -> {
            this.walkSpeed = config.getWalkSpeed();
            this.rideSpeed = config.getRideSpeed();
            this.flySpeed = config.getFlySpeed();
            this.floatDown = config.canFloat();
        });
        VersionHelper.setAttributes(this, this.walkSpeed, this.flySpeed);
        EntityUtils.fetchTeam(user.getPlayer()).addEntry(this.cK().toString());
        this.verticalWorldConfines = ConfigOption.INSTANCE.MISC_TOGGLES_WORLD_CONFINES_PET_LIMITS.getValue();
        this.maxHeight = this.getEntity().getWorld().getMaxHeight();
        this.minHeight = this.getEntity().getWorld().getMinHeight();
    }

    @Override
    public void fetchPetDebugInformation(JsonObject debugInfo) {
        EntityPlayer player = (EntityPlayer)VersionHelper.getEntityHandle((Entity)this.getPetUser().getPlayer());
        debugInfo.set("display-name", new JsonObject().add("name", this.petName).add("display-name-visibility (config)", this.displayNameVisibility).add("hide-name-while-shifting (config)", this.hideNameShifting).add("actually-visible", this.cP()));
        debugInfo.set("data", new JsonObject().add("jump-height", 0.5).add("frozen", this.frozen).add("on-fire", this.onFire).add("silent", this.silent).add("visible", this.visible).add("auto-remove", new JsonObject().add("auto-remove-enabled", this.autoRemoveToggle).add("stand-still-ticks", this.standStillTicks).add("auto-remove-tick", this.autoRemoveTick)).add("hover-remove", new JsonObject().add("hover-ticks", this.hoverTickCount).add("hover-ticks-target", 6000)));
        int maxRange = ConfigOption.INSTANCE.PATHFINDING_MAX_DISTANCE.getValue();
        debugInfo.set("follow-player", new JsonObject().add("distance", this.g((net.minecraft.world.entity.Entity)player)).add("max-follow-distance (config)", maxRange).add("should-follow", this.g((net.minecraft.world.entity.Entity)player) < (double)(maxRange * maxRange)));
        int teleportDistance = ConfigOption.INSTANCE.PATHFINDING_TELEPORT_DISTANCE.getValue();
        debugInfo.set("teleport-pet", new JsonObject().add("distance", this.f((net.minecraft.world.entity.Entity)player)).add("teleport-distance (config)", teleportDistance).add("should-teleport", this.g((net.minecraft.world.entity.Entity)player) >= (double)teleportDistance).add("should-force-teleport", this.f((net.minecraft.world.entity.Entity)player) >= 80.0f));
        JsonObject petData = new JsonObject();
        EntityPet entityPet = this;
        if (entityPet instanceof IEntityControllerPet) {
            IEntityControllerPet controllerPet = (IEntityControllerPet)((Object)entityPet);
            controllerPet.getVisibleEntity().fetchPetDebugInformation(petData);
        } else {
            this.fetchPetData(petData);
        }
        debugInfo.set("pet-" + this.getPetType().getName() + "-data", petData);
    }

    public void fetchPetData(JsonObject data) {
    }

    public void setDisplayName(boolean displayName) {
        this.displayNameVisibility = displayName;
    }

    public boolean fy() {
        return this.bB;
    }

    public double getJumpHeight() {
        return 0.5;
    }

    @Override
    public void teleportToOwner() {
        this.getPetUser().getUserLocation().ifPresent(location -> {
            this.a_(location.getX(), location.getY(), location.getZ());
            SimplePets.getPetUtilities().runPetCommands(CommandReason.TELEPORT, this.getPetUser(), this.getPetType());
            SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TELEPORT, this.getPetUser().getPlayer(), (Location)location);
        });
    }

    @Override
    public void setGlowColor(ChatColor glowColor) {
        if (this.glowColor == glowColor) {
            return;
        }
        this.glowColor = glowColor;
    }

    @Override
    public ChatColor getGlowColor() {
        return this.glowColor;
    }

    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f, EntityDamageEvent event) {
        return false;
    }

    protected boolean damageEntity0(DamageSource damagesource, float f) {
        return false;
    }

    protected boolean actuallyHurt(DamageSource damagesource, float f) {
        return false;
    }

    protected boolean actuallyHurt(DamageSource damageSource, float f, EntityDamageEvent event) {
        return false;
    }

    protected void H() {
        this.ch.a(1, (PathfinderGoal)new PathfinderGoalFloat((EntityInsentient)this));
        if (this.getPetType() != PetType.SHULKER) {
            if (ConfigOption.INSTANCE.LEGACY_PATHFINDING_ENABLED.getValue().booleanValue()) {
                this.ch.a(2, (PathfinderGoal)new LegacyPathfinderFollowPlayer(this, 3, 10));
            } else {
                this.ch.a(2, (PathfinderGoal)new PathfinderFollowPlayer(this));
            }
        }
        this.ch.a(3, (PathfinderGoal)new PathfinderGoalLookAtOwner(this, 3.0f, 0.2f));
        this.ch.a(3, (PathfinderGoal)new PathfinderGoalRandomLookaround((EntityInsentient)this));
    }

    @Override
    public boolean isBurning() {
        return this.onFire;
    }

    @Override
    public void setBurning(boolean var) {
        this.onFire = var;
        this.h(var ? 150 : 0);
    }

    @Override
    public boolean isFrozen() {
        return this.cA();
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        this.k(frozen ? 150 : 0);
    }

    @Override
    public void setPetName(String name) {
        Optional<IPetConfig> config;
        if ((name == null || name.isEmpty()) && (config = SimplePets.getPetConfigManager().getPetConfig(this.getPetType())).isPresent()) {
            name = config.get().getDisplayName();
        }
        String newName = name.replace("%player%", this.getPetUser().getPlayer().getName());
        EntityNameChangeEvent event = new EntityNameChangeEvent(this, newName);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.petName = Colorize.translateBungeeHex(event.getPrefix()) + SimplePets.getPetUtilities().translatePetName(event.getName()) + Colorize.translateBungeeHex(event.getSuffix());
        this.getBukkitEntity().setCustomNameVisible(ConfigOption.INSTANCE.PET_TOGGLES_SHOW_NAMES.getValue().booleanValue());
        this.getBukkitEntity().setCustomName(this.petName);
    }

    @Override
    public Optional<String> getPetName() {
        if (this.petName != null) {
            return Optional.of(this.petName);
        }
        if (this.getPetUser().getPetName(this.getPetType()).isPresent()) {
            return this.getPetUser().getPetName(this.getPetType());
        }
        return Optional.empty();
    }

    @Override
    public void handleAdditionalStorage(String pluginKey, Function<StorageTagCompound, StorageTagCompound> compound) {
        this.additional.put(pluginKey, compound.apply(this.additional.getOrDefault(pluginKey, new StorageTagCompound())));
    }

    @Override
    public UUID getOwnerUUID() {
        return this.getPetUser().getPlayer().getUniqueId();
    }

    @Override
    public double getPetScale() {
        return this.h(GenericAttributes.z).g();
    }

    @Override
    public void setPetScale(double scale) {
        this.h(GenericAttributes.z).a(scale);
    }

    @Override
    public boolean isFullSize() {
        return this.getPetScale() == 1.0;
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = new StorageTagCompound();
        object.setString("PetType", this.getPetType().getName());
        object.setFloat("health", this.eL());
        object.setString("ownerName", this.getPetUser().getOwnerName());
        this.getPetUser().getPetName(this.getPetType()).ifPresent(name -> object.setString("name", name.replace('\u00a7', '&')));
        object.setBoolean("silent", this.silent);
        if (!this.isPetVisible()) {
            object.setBoolean("visible", !this.isPetVisible());
        }
        if (!this.additional.isEmpty()) {
            StorageTagCompound additional = new StorageTagCompound();
            this.additional.forEach(additional::setTag);
            object.setTag("additional", additional);
        }
        object.setDouble("scale", this.getPetScale());
        object.setBoolean("frozen", this.isFrozen());
        object.setBoolean("burning", this.isBurning());
        object.setEnum("glow-color", (Enum)this.getGlowColor());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        EntityPose pose;
        if (object.hasKey("health")) {
            float health = object.getFloat("health", 20.0f);
            if (health >= 2048.0f) {
                health = 2047.0f;
            }
            if (health < 1.0f) {
                health = 1.0f;
            }
            this.x(health);
        }
        if (object.hasKey("name")) {
            String name = object.getString("name");
            if (name != null) {
                name = name.replace("~", " ");
            }
            this.setPetName(name);
        }
        if (object.hasKey("glow-color")) {
            this.setGlowColor(object.getEnum("glow-color", ChatColor.class, ChatColor.WHITE));
        }
        if (object.hasKey("silent")) {
            this.silent = object.getBoolean("silent");
        }
        if (object.hasKey("visible")) {
            this.setPetVisible(object.getBoolean("visible"));
        }
        if (object.hasKey("additional")) {
            StorageTagCompound additional = object.getCompoundTag("additional");
            additional.getKeySet().forEach(pluginKey -> this.additional.put((String)pluginKey, additional.getCompoundTag((String)pluginKey)));
        }
        if (object.hasKey("frozen")) {
            this.setFrozen(object.getBoolean("frozen", false));
        }
        if (object.hasKey("burning")) {
            this.setBurning(object.getBoolean("burning", false));
        }
        if (object.hasKey("pose") && (pose = object.getEnum("pose", EntityPose.class)) != null) {
            this.b(pose);
        }
        if (object.hasKey("walkSpeed")) {
            this.walkSpeed = object.getDouble("walkSpeed");
            VersionHelper.setAttributes(this, this.walkSpeed, -1.0);
        }
        if (object.hasKey("rideSpeed")) {
            this.rideSpeed = object.getDouble("rideSpeed");
        }
        if (object.hasKey("flySpeed")) {
            this.flySpeed = object.getDouble("flySpeed");
            VersionHelper.setAttributes(this, -1.0, this.flySpeed);
        }
        if (object.hasKey("scale")) {
            this.setPetScale(object.getDouble("scale"));
        }
    }

    @Override
    public boolean isPetVisible() {
        return this.visible;
    }

    @Override
    public void setPetVisible(boolean visible) {
        this.visible = visible;
        this.l(!visible);
    }

    @Override
    public boolean isPetSilent() {
        return this.silent;
    }

    @Override
    public void setPetSilent(boolean silent) {
        this.silent = silent;
    }

    @Override
    public Entity getEntity() {
        return this.getBukkitEntity();
    }

    @Override
    public boolean attachOwner() {
        this.bR();
        Player owner = this.getPetUser().getPlayer();
        if (owner != null) {
            SimplePets.getPetUtilities().runPetCommands(CommandReason.RIDE, this.getPetUser(), this.getPetType());
            if (!this.doIndirectAttach) {
                return VersionHelper.getEntityHandle((Entity)owner).o((net.minecraft.world.entity.Entity)this);
            }
            return SeatEntity.attach(VersionHelper.getEntityHandle((Entity)owner), (net.minecraft.world.entity.Entity)this);
        }
        return false;
    }

    @Override
    public PetType getPetType() {
        return super.getPetType();
    }

    @Override
    public PetUser getPetUser() {
        return super.getUser();
    }

    @Override
    public EntityType getPetEntityType() {
        return this.getPetType().getEntityType();
    }

    public void setIgnoreVanish(boolean ignoreVanish) {
        this.ignoreVanish = ignoreVanish;
    }

    public boolean canIgnoreVanish() {
        return this.ignoreVanish;
    }

    private boolean isOnGround(net.minecraft.world.entity.Entity entity) {
        Block block = entity.getBukkitEntity().getLocation().subtract(0.0, 0.5, 0.0).getBlock();
        return block.getType().isSolid() || block.isLiquid();
    }

    protected boolean isOwnerRiding() {
        if (this.aR.size() == 0) {
            return false;
        }
        EntityHuman owner = (EntityHuman)VersionHelper.getEntityHandle((Entity)this.getPetUser().getPlayer());
        return this.dc().anyMatch(e -> e.equals((Object)owner));
    }

    public void g() {
        super.g();
        CraftEntity bukkitEntity = this.getBukkitEntity();
        if (this.autoRemoveToggle && bukkitEntity != null) {
            Location location = bukkitEntity.getLocation();
            if (this.blockX != location.getBlockX() || this.blockY != location.getBlockY() || this.blockZ != location.getBlockZ()) {
                this.blockX = location.getBlockX();
                this.blockY = location.getBlockY();
                this.blockZ = location.getBlockZ();
                if (this.standStillTicks != 0) {
                    this.standStillTicks = 0;
                }
            } else {
                if (this.standStillTicks == this.autoRemoveTick) {
                    if (this.getPetUser() != null) {
                        this.getPetUser().removePet(this.getPetType());
                    } else {
                        bukkitEntity.remove();
                    }
                }
                ++this.standStillTicks;
            }
        }
        if (this.getPetUser() == null || this.getPetUser().getPlayer() == null || !this.getPetUser().getPlayer().isOnline()) {
            if (bukkitEntity != null) {
                bukkitEntity.remove();
            }
            return;
        }
        if (this.verticalWorldConfines && (this.dE() > (double)this.maxHeight || (double)this.minHeight > this.dE())) {
            this.getPetUser().removePet(this.getPetType());
            return;
        }
        if (this.isOnGround()) {
            if (this.hoverTickCount != 0) {
                this.hoverTickCount = 0;
            }
        } else {
            if (this.hoverTickCount == 6000) {
                if (this.getPetUser() != null) {
                    this.getPetUser().removePet(this.getPetType());
                } else {
                    bukkitEntity.remove();
                }
            }
            ++this.hoverTickCount;
        }
        if (this.getPetUser().isPetVehicle(this.getPetType()) && this.floatDown && !this.isOnGround((net.minecraft.world.entity.Entity)this)) {
            this.n(this.dA().d, this.dA().e * 0.4, this.dA().f);
        }
        if (this.frozen && this.cy() < 140) {
            this.k(150);
        }
        if (this.onFire && this.aH() < 140) {
            this.h(150);
        }
        if (this.getPetUser().getPlayer() != null) {
            boolean ownerVanish;
            Player player = this.getPetUser().getPlayer();
            boolean shifting = player.isSneaking();
            if (this.displayNameVisibility && this.hideNameShifting && this.getPetType() != PetType.SHULKER) {
                this.getEntity().setCustomNameVisible(!shifting);
            }
            boolean bl = ownerVanish = VersionHelper.getEntityHandle((Entity)player).cs() || SimplePets.getPetUtilities().isVanished(player);
            if (ownerVanish && ConfigOption.INSTANCE.MISC_TOGGLES_REMOVED_VANISH.getValue().booleanValue()) {
                this.getPetUser().removePet(this.getPetType());
                return;
            }
            if (!this.canIgnoreVanish() && ConfigOption.INSTANCE.MISC_TOGGLES_PET_VANISHING.getValue().booleanValue() && this.isPetVisible()) {
                if (ownerVanish != this.cs()) {
                    if (this.isGlowing && !ownerVanish) {
                        this.glowHandler(player, false);
                    }
                    this.l(!this.cs());
                } else if (ownerVanish && this.glowVanishToggle && VersionHelper.getEntityHandle((Entity)player).cs()) {
                    this.glowHandler(player, true);
                }
            }
            if (this.getPetUser().isPetHat(this.getPetType())) {
                this.v(player.getLocation().getYaw());
                this.aa = this.dP();
            }
            double current = this.h(GenericAttributes.w).g();
            if (this.isOwnerRiding()) {
                if (current != this.rideSpeed) {
                    VersionHelper.setAttributes(this, this.rideSpeed, -1.0);
                }
            } else if (current != this.walkSpeed) {
                VersionHelper.setAttributes(this, this.walkSpeed, -1.0);
            }
        }
    }

    public void X() {
        if (this.silent || this.cs()) {
            return;
        }
        SimplePets.getPetConfigManager().getPetConfig(this.getPetType()).ifPresent(config -> {
            SoundMaker sound = config.getSound();
            if (sound != null) {
                sound.playSound(this.getEntity());
            }
        });
    }

    public void a(SoundEffect soundeffect, float f, float f1) {
        if (this.silent || this.cs()) {
            return;
        }
        SimplePets.getPetConfigManager().getPetConfig(this.getPetType()).ifPresent(config -> {
            SoundMaker sound = config.getSound();
            if (sound != null) {
                sound.playSound(this.getEntity());
            }
        });
    }

    public EntityTypes<?> ap() {
        return this.rawEntityType;
    }

    private void glowHandler(Player player, boolean glow) {
        try {
            Entity entity = this.getEntity();
            EntityPet entityPet = this;
            if (entityPet instanceof IEntityControllerPet) {
                IEntityControllerPet controllerPet = (IEntityControllerPet)((Object)entityPet);
                entity = controllerPet.getVisibleEntity().getEntity();
            }
            this.isGlowing = glow;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        PetMoveEvent moveEvent = new PetMoveEvent(this);
        Bukkit.getServer().getPluginManager().callEvent((Event)moveEvent);
        if (moveEvent.isCancelled()) {
            return;
        }
        super.a(enummovetype, vec3d);
    }

    public boolean aD() {
        return true;
    }

    @Override
    protected void bZ() {
    }

    public boolean isOnGround() {
        Block block = this.getBukkitEntity().getLocation().subtract(0.0, 0.5, 0.0).getBlock();
        return block.getType().isSolid() || block.isLiquid();
    }

    private static AttributeProvider.Builder createAttributes(EntityPet entityPet) {
        AttributeProvider.Builder builder = EntityInsentient.I();
        if (entityPet instanceof IFlyableEntity) {
            builder.a(GenericAttributes.m, 1.0);
        }
        builder.a(GenericAttributes.z, 1.0);
        builder.a(GenericAttributes.C, 1.0);
        return builder.a(GenericAttributes.w, 1.0);
    }
}

