/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import simplepets.brainsynder.api.entity.passive.IEntityStriderPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntityStriderPet
extends EntityAgeablePet
implements IEntityStriderPet {
    private static final DataWatcherObject<Integer> BOOST_TIME = DataWatcher.a(EntityStriderPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> COLD = DataWatcher.a(EntityStriderPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityStriderPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bv, type, user);
        this.doIndirectAttach = true;
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("cold", this.isCold());
        data.add("saddled", this.isPetSaddled());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(BOOST_TIME, 0);
        dataAccess.define(COLD, false);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("cold", this.isCold());
        object.setBoolean("saddled", this.isPetSaddled());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("cold")) {
            this.setCold(object.getBoolean("cold"));
        }
        if (object.hasKey("saddled")) {
            this.setPetSaddled(object.getBoolean("saddled"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isPetSaddled() {
        return !this.a(EnumItemSlot.h).f();
    }

    @Override
    public void setPetSaddled(boolean saddled) {
        this.a(EnumItemSlot.h, saddled ? new ItemStack((IMaterial)Items.ov) : ItemStack.l);
    }

    @Override
    public boolean isCold() {
        return (Boolean)this.ay.a(COLD);
    }

    @Override
    public void setCold(boolean cold) {
        this.ay.a(COLD, (Object)cold);
    }
}

