/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntitySlimePet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.sounds.SoundMaker;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_6.entity.controller.ControllerSlime;
import simplepets.brainsynder.versions.v1_21_6.helper.VersionHelper;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntitySlimePet
extends EntityPetOverride
implements IEntitySlimePet {
    private static final DataWatcherObject<Integer> SIZE = DataWatcher.a(EntitySlimePet.class, (DataWatcherSerializer)DataWatcherRegistry.b);

    public EntitySlimePet(PetType type, PetUser user) {
        this((EntityTypes<? extends EntityInsentient>)EntityTypes.bj, type, user);
    }

    public EntitySlimePet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
        this.ce = new ControllerSlime(this);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("size", this.getSize());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(SIZE, 2);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setInteger("size", this.getSize());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("size")) {
            this.setSize(object.getInteger("size"));
        }
        super.applyCompound(object);
    }

    @Override
    public int getSize() {
        return (Integer)this.ay.a(SIZE);
    }

    @Override
    public void setSize(int i) {
        this.ay.a(SIZE, (Object)i);
        VersionHelper.setAttributes(this, 0.2 + 0.1 * (double)i, -1.0);
    }

    public void playJumpSound() {
        if (this.isPetSilent()) {
            return;
        }
        SimplePets.getPetConfigManager().getPetConfig(this.getPetType()).ifPresent(config -> {
            SoundMaker sound = config.getSound();
            if (sound != null) {
                sound.playSound(this.getEntity());
            }
        });
    }
}

