/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntityPufferFishPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.PufferState;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityFishPet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntityPufferFishPet
extends EntityFishPet
implements IEntityPufferFishPet {
    private static final DataWatcherObject<Integer> PUFF_STATE = DataWatcher.a(EntityPufferFishPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);

    public EntityPufferFishPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.aZ, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("state", this.getPuffState().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(PUFF_STATE, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("size", this.getPuffState());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("size")) {
            this.setPuffState(object.getEnum("size", PufferState.class, PufferState.SMALL));
        }
        super.applyCompound(object);
    }

    @Override
    public PufferState getPuffState() {
        return PufferState.getByID((Integer)this.ay.a(PUFF_STATE));
    }

    @Override
    public void setPuffState(PufferState state) {
        this.ay.a(PUFF_STATE, (Object)state.ordinal());
    }
}

