/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import simplepets.brainsynder.api.entity.passive.IEntityHorsePet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.horse.HorseArmorType;
import simplepets.brainsynder.api.wrappers.horse.HorseColorType;
import simplepets.brainsynder.api.wrappers.horse.HorseStyleType;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.branch.EntityHorseAbstractPet;
import simplepets.brainsynder.versions.v1_21_6.helper.VersionHelper;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntityHorsePet
extends EntityHorseAbstractPet
implements IEntityHorsePet {
    private static final DataWatcherObject<Integer> HORSE_VARIANT = DataWatcher.a(EntityHorsePet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private HorseArmorType armor = null;

    public EntityHorsePet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.an, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("armor", this.getArmor().name());
        data.add("color", this.getColor().name());
        data.add("style", this.getStyle().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(HORSE_VARIANT, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setString("armor", this.getArmor().name());
        object.setString("color", this.getColor().name());
        object.setString("style", this.getStyle().name());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("armor")) {
            this.setArmor(HorseArmorType.getByName(object.getString("armor")));
        }
        if (object.hasKey("color")) {
            this.setColor(HorseColorType.getByName(object.getString("color")));
        }
        if (object.hasKey("style")) {
            this.setStyle(HorseStyleType.getByName(object.getString("style")));
        }
        super.applyCompound(object);
    }

    @Override
    public HorseArmorType getArmor() {
        if (this.armor == null) {
            return HorseArmorType.NONE;
        }
        return this.armor;
    }

    @Override
    public void setArmor(HorseArmorType armor) {
        if (!armor.isSupported()) {
            return;
        }
        this.armor = armor;
        if (armor == null) {
            this.a(EnumItemSlot.g, Items.a.m());
            return;
        }
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.N);
        this.a(EnumItemSlot.g, ((Item)VersionHelper.getRegistryValue(registry, armor.getKey())).m());
    }

    @Override
    public HorseStyleType getStyle() {
        return HorseStyleType.values()[(this.getTypeVariant() & 0xFF00) >> 8];
    }

    @Override
    public void setStyle(HorseStyleType style) {
        this.updateHorse(this.getColor(), style);
    }

    @Override
    public HorseColorType getColor() {
        return HorseColorType.values()[this.getTypeVariant() & 0xFF];
    }

    @Override
    public void setColor(HorseColorType color) {
        this.updateHorse(color, this.getStyle());
    }

    private int getTypeVariant() {
        return (Integer)this.ay.a(HORSE_VARIANT);
    }

    private void updateHorse(HorseColorType colorType, HorseStyleType styleType) {
        this.ay.a(HORSE_VARIANT, (Object)(colorType.ordinal() & 0xFF | styleType.ordinal() << 8 & 0xFF00));
    }
}

