/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import java.util.Optional;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntityFoxPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.FoxType;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntityFoxPet
extends EntityAgeablePet
implements IEntityFoxPet {
    private static final DataWatcherObject<Integer> TYPE = DataWatcher.a(EntityFoxPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> FOX_FLAGS = DataWatcher.a(EntityFoxPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    private static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> OWNER = DataWatcher.a(EntityFoxPet.class, (DataWatcherSerializer)DataWatcherRegistry.r);
    private static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> OTHER_TRUSTED = DataWatcher.a(EntityFoxPet.class, (DataWatcherSerializer)DataWatcherRegistry.r);

    public EntityFoxPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ab, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("type", this.getFoxType().name());
        data.add("interested", this.isInterested());
        data.add("crouching", this.cl());
        data.add("sitting", this.isSitting());
        data.add("sleep", this.isPetSleeping());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(OWNER, Optional.empty());
        dataAccess.define(OTHER_TRUSTED, Optional.empty());
        dataAccess.define(TYPE, FoxType.RED.ordinal());
        dataAccess.define(FOX_FLAGS, (byte)0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setString("type", this.getFoxType().name());
        compound.setBoolean("interested", this.isInterested());
        compound.setBoolean("crouching", this.cl());
        compound.setBoolean("sitting", this.isSitting());
        compound.setBoolean("sleep", this.isPetSleeping());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("type")) {
            this.setFoxType(object.getEnum("type", FoxType.class, FoxType.RED));
        }
        if (object.hasKey("interested")) {
            this.setInterested(object.getBoolean("interested"));
        }
        if (object.hasKey("crouching")) {
            this.setCrouching(object.getBoolean("crouching"));
        }
        if (object.hasKey("sitting")) {
            this.setSitting(object.getBoolean("sitting"));
        }
        if (object.hasKey("sleep")) {
            this.setPetSleeping(object.getBoolean("sleep"));
        }
        super.applyCompound(object);
    }

    @Override
    public FoxType getFoxType() {
        return FoxType.getByID((Integer)this.ay.a(TYPE));
    }

    @Override
    public void setFoxType(FoxType type) {
        this.ay.a(TYPE, (Object)type.ordinal());
    }

    @Override
    public boolean isPetSleeping() {
        return this.getSpecialFlag(32);
    }

    @Override
    public void setPetSleeping(boolean sleeping) {
        this.setSpecialFlag(32, sleeping);
    }

    @Override
    public void setSpecialFlag(int flag, boolean value) {
        if (value) {
            this.ay.a(FOX_FLAGS, (Object)((byte)((Byte)this.ay.a(FOX_FLAGS) | flag)));
        } else {
            this.ay.a(FOX_FLAGS, (Object)((byte)((Byte)this.ay.a(FOX_FLAGS) & ~flag)));
        }
    }

    @Override
    public boolean getSpecialFlag(int flag) {
        return ((Byte)this.ay.a(FOX_FLAGS) & flag) != 0;
    }
}

