/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.golem.CopperGolemState;
import net.minecraft.world.level.block.WeatheringCopper;
import simplepets.brainsynder.api.entity.passive.IEntityCopperGolemPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.OxidationWrapper;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

@SupportedVersion(version=ServerVersion.v1_21_9)
public class EntityCopperGolemPet
extends EntityPetOverride
implements IEntityCopperGolemPet {
    private static final DataWatcherObject<WeatheringCopper.a> OXIDATION_STATE = DataWatcher.a(EntityCopperGolemPet.class, (DataWatcherSerializer)DataWatcherRegistry.WEATHERING_COPPER_STATE);
    private static final DataWatcherObject<CopperGolemState> COPPER_GOLEM_STATE = DataWatcher.a(EntityCopperGolemPet.class, (DataWatcherSerializer)DataWatcherRegistry.COPPER_GOLEM_STATE);

    public EntityCopperGolemPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.COPPER_GOLEM, type, user);
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(OXIDATION_STATE, WeatheringCopper.a.a);
        dataAccess.define(COPPER_GOLEM_STATE, CopperGolemState.IDLE);
    }

    @Override
    public OxidationWrapper getOxidation() {
        return OxidationWrapper.valueOf(((WeatheringCopper.a)this.ay.a(OXIDATION_STATE)).name());
    }

    @Override
    public void setOxidation(OxidationWrapper wrapper) {
        this.ay.a(OXIDATION_STATE, (Object)WeatheringCopper.a.valueOf((String)wrapper.name()));
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("oxidation", this.getOxidation().name());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setEnum("oxidation", this.getOxidation());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("oxidation")) {
            this.setOxidation(object.getEnum("oxidation", OxidationWrapper.class, OxidationWrapper.UNAFFECTED));
        }
        if (object.hasKey("golem_state")) {
            CopperGolemState state = CopperGolemState.valueOf((String)object.getString("golem_state").toUpperCase());
            this.ay.a(COPPER_GOLEM_STATE, (Object)state);
        }
        super.applyCompound(object);
    }
}

