/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.branch;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.item.Items;
import simplepets.brainsynder.api.entity.misc.IHorseAbstract;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntityHorseAbstractPet
extends EntityAgeablePet
implements IHorseAbstract {
    private static final DataWatcherObject<Byte> STATUS = DataWatcher.a(EntityHorseAbstractPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    protected boolean isJumping;
    private boolean isSaddled = false;

    public EntityHorseAbstractPet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
        this.doIndirectAttach = true;
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("saddled", this.isPetSaddled());
        data.add("eating", this.isEating());
        data.add("angry", this.isAngry());
        data.add("rearing", this.isRearing());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(STATUS, (byte)0);
    }

    @Override
    public boolean isPetSaddled() {
        return this.isSaddled;
    }

    @Override
    public void setPetSaddled(boolean saddled) {
        this.isSaddled = saddled;
        this.a(EnumItemSlot.h, saddled ? Items.ov.m() : Items.a.m());
    }

    @Override
    public boolean fy() {
        return this.isJumping;
    }

    public void setIsJumping(boolean flag) {
        this.isJumping = flag;
    }

    public double getCustomJump() {
        return this.i(GenericAttributes.p);
    }

    @Override
    public void setSpecialFlag(int flag, boolean value) {
        byte b0 = (Byte)this.ay.a(STATUS);
        if (value) {
            this.ay.a(STATUS, (Object)((byte)(b0 | flag)));
        } else {
            this.ay.a(STATUS, (Object)((byte)(b0 & ~flag)));
        }
    }

    @Override
    public boolean getSpecialFlag(int flag) {
        return ((Byte)this.ay.a(STATUS) & flag) != 0;
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("saddled", this.isPetSaddled());
        object.setBoolean("eating", this.isEating());
        object.setBoolean("angry", this.isAngry());
        object.setBoolean("rearing", this.isRearing());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("saddled")) {
            this.setPetSaddled(object.getBoolean("saddled"));
        }
        if (object.hasKey("eating")) {
            this.setEating(object.getBoolean("eating"));
        }
        if (object.hasKey("angry")) {
            this.setAngry(object.getBoolean("angry"));
        }
        if (object.hasKey("rearing")) {
            this.setRearing(object.getBoolean("rearing"));
        }
        super.applyCompound(object);
    }
}

