/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.list;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import simplepets.brainsynder.api.entity.passive.IEntityRabbitPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.RabbitType;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_11.entity.controller.ControllerJumpRabbit;
import simplepets.brainsynder.versions.v1_21_11.entity.controller.ControllerMoveRabbit;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;

public class EntityRabbitPet
extends EntityAgeablePet
implements IEntityRabbitPet {
    private static final DataWatcherObject<Integer> RABBIT_TYPE = DataWatcher.a(EntityRabbitPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private int jumpTicks;
    private int jumpDuration;
    private boolean onGroundLastTick = false;
    private int ticksUntilJump = 0;

    public EntityRabbitPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bg, type, user);
        this.cq = new ControllerJumpRabbit(this);
        this.cp = new ControllerMoveRabbit(this);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("variant", this.getRabbitType().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(RABBIT_TYPE, 0);
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("variant")) {
            this.setRabbitType(object.getEnum("variant", RabbitType.class, RabbitType.BROWN));
        }
        super.applyCompound(object);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("variant", this.getRabbitType());
        return object;
    }

    @Override
    public RabbitType getRabbitType() {
        return RabbitType.getByID((Integer)this.az.a(RABBIT_TYPE));
    }

    @Override
    public void setRabbitType(RabbitType type) {
        this.az.a(RABBIT_TYPE, (Object)type.getId());
    }

    @Override
    public void g() {
        super.g();
        this.onGroundLastTick = this.bc;
    }

    protected void a(WorldServer worldserver) {
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.bc) {
            ControllerJumpRabbit controller;
            if (!this.onGroundLastTick) {
                this.t(false);
                this.scheduleJump();
            }
            if (!(controller = (ControllerJumpRabbit)this.L()).wantJump()) {
                if (this.cp.b() && this.ticksUntilJump == 0) {
                    PathEntity pathentity = this.getPath();
                    Vec3D vec3d = new Vec3D(this.cp.d(), this.cp.e(), this.cp.f());
                    if (pathentity != null && !pathentity.c()) {
                        vec3d = pathentity.a((Entity)this);
                    }
                    this.lookTowards(vec3d.g, vec3d.i);
                    this.reseter();
                }
            } else if (!controller.canJump()) {
                ((ControllerJumpRabbit)this.cq).setCanJump(true);
            }
        }
        this.onGroundLastTick = this.bc;
    }

    private void scheduleJump() {
        this.doScheduleJump();
        ((ControllerJumpRabbit)this.cq).setCanJump(false);
    }

    private void doScheduleJump() {
        this.ticksUntilJump = this.cp.c() < 2.2 ? 10 : 1;
        ((ControllerJumpRabbit)this.cq).setCanJump(false);
    }

    private void lookTowards(double d0, double d1) {
        this.v((float)(MathHelper.d((double)(d1 - this.dV()), (double)(d0 - this.dP())) * 57.2957763671875) - 90.0f);
    }

    public void d_() {
        super.d_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.t(false);
        }
    }

    public void setSpeedModifier(double d0) {
        this.N().a(d0);
        this.cp.a(this.cp.d(), this.cp.e(), this.cp.f(), d0);
    }

    private PathEntity getPath() {
        try {
            return this.cr.j();
        }
        catch (NoSuchMethodError ex) {
            try {
                return (PathEntity)Reflection.getMethod(NavigationAbstract.class, "getPath", new Class[0]).invoke((Object)this.cr, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public void reseter() {
        this.t(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }
}

