/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import simplepets.brainsynder.api.entity.passive.IEntityBeePet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;

public class EntityBeePet
extends EntityAgeablePet
implements IEntityBeePet {
    private static final DataWatcherObject<Byte> FLAGS = DataWatcher.a(EntityBeePet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    private static final DataWatcherObject<Long> ANGER = DataWatcher.a(EntityBeePet.class, (DataWatcherSerializer)DataWatcherRegistry.c);

    public EntityBeePet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.n, type, user);
        this.cp = new ControllerMoveFlying((EntityInsentient)this, 20, true);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("angry", this.isAngry());
        data.add("missing-stinger", this.hasStung());
        data.add("flipped", this.isFlipped());
        data.add("nectar", this.hasNectar());
    }

    protected NavigationAbstract b(World level) {
        NavigationFlying navigation = new NavigationFlying((EntityInsentient)this, level);
        navigation.e(false);
        navigation.a(false);
        return navigation;
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(FLAGS, (byte)4);
        dataAccess.define(ANGER, 0L);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("angry", this.isAngry());
        object.setBoolean("nectar", this.hasNectar());
        object.setBoolean("stinger", this.hasStung());
        object.setBoolean("flipped", this.isFlipped());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("angry")) {
            this.setAngry(object.getBoolean("angry"));
        }
        if (object.hasKey("nectar")) {
            this.setHasNectar(object.getBoolean("nectar"));
        }
        if (object.hasKey("stinger")) {
            this.setHasStung(object.getBoolean("stinger"));
        }
        if (object.hasKey("flipped")) {
            this.setFlipped(object.getBoolean("flipped"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isAngry() {
        return (Long)this.az.a(ANGER) > 0L;
    }

    @Override
    public void setAngry(boolean angry) {
        this.az.a(ANGER, (Object)(angry ? 25562256L : 0L));
    }

    @Override
    public void setSpecialFlag(int flag, boolean value) {
        byte flagByte = (Byte)this.az.a(FLAGS);
        flagByte = value ? (byte)(flagByte | flag) : (byte)(flagByte & ~flag);
        if (flagByte != (Byte)this.az.a(FLAGS)) {
            this.az.a(FLAGS, (Object)flagByte);
        }
    }

    @Override
    public boolean getSpecialFlag(int flag) {
        return ((Byte)this.az.a(FLAGS) & flag) != 0;
    }

    @Override
    public void m(Vec3D vec3) {
        if (this.isOwnerRiding()) {
            super.m(vec3);
            this.s(false);
            return;
        }
        if (this.by()) {
            this.a(0.02f, vec3);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c((double)0.8f));
        } else if (this.bN()) {
            this.a(0.02f, vec3);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c(0.5));
        } else {
            this.a(this.fM(), vec3);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c(0.8100000262260437));
        }
        this.s(false);
    }
}

