/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntityPolarBearPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;

public class EntityPolarBearPet
extends EntityAgeablePet
implements IEntityPolarBearPet {
    private static final DataWatcherObject<Boolean> IS_STANDING = DataWatcher.a(EntityPolarBearPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityPolarBearPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.aZ, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("standing", this.isStanding());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(IS_STANDING, false);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("standing", this.isStanding());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("standing")) {
            this.setStandingUp(object.getBoolean("standing", false));
        }
        super.applyCompound(object);
    }

    @Override
    public void setStandingUp(boolean flag) {
        this.az.a(IS_STANDING, (Object)flag);
    }

    @Override
    public boolean isStanding() {
        return (Boolean)this.az.a(IS_STANDING);
    }
}

