/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import simplepets.brainsynder.api.entity.passive.IEntityPigPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.TemperatureVariant;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;
import simplepets.brainsynder.versions.v1_21_10.utils.VariantUtils;

public class EntityPigPet
extends EntityAgeablePet
implements IEntityPigPet {
    private static final DataWatcherObject<Integer> DATA_BOOST_TIME = DataWatcher.a(EntityPigPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<PigVariant>> VARIANT = DataWatcher.a(EntityPigPet.class, (DataWatcherSerializer)DataWatcherRegistry.C);
    private TemperatureVariant variant = TemperatureVariant.TEMPERATE;

    public EntityPigPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.aV, type, user);
        this.doIndirectAttach = true;
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DATA_BOOST_TIME, 0);
        dataAccess.define(VARIANT, VariantUtils.getDefaultOrAny(this.ej(), PigVariants.a));
    }

    @Override
    public void setVariant(TemperatureVariant variant) {
        this.variant = variant;
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.bi);
        this.az.a(VARIANT, (Object)registry.e((Object)((PigVariant)registry.a(CraftNamespacedKey.toMinecraft((NamespacedKey)variant.getKey())))));
    }

    @Override
    public TemperatureVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean isPetSaddled() {
        return this.a(EnumItemSlot.h).a(Items.oR);
    }

    @Override
    public void setPetSaddled(boolean saddled) {
        if (saddled) {
            this.setItemSlot(EnumItemSlot.h, Items.oR.m(), true);
        } else {
            this.setItemSlot(EnumItemSlot.h, ItemStack.l, true);
        }
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("saddled", this.isPetSaddled());
        data.add("variant", this.variant.getKey().toString());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("saddled", this.isPetSaddled());
        object.setEnum("variant", this.getVariant());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("saddled")) {
            this.setPetSaddled(object.getBoolean("saddled"));
        }
        if (object.hasKey("variant")) {
            this.setVariant(object.getEnum("variant", TemperatureVariant.class, TemperatureVariant.TEMPERATE));
        }
        super.applyCompound(object);
    }
}

