/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import java.util.List;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import simplepets.brainsynder.api.entity.passive.IEntityPandaPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.PandaGene;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;

public class EntityPandaPet
extends EntityAgeablePet
implements IEntityPandaPet {
    private static final DataWatcherObject<Integer> ASK_FOR_BAMBOO_TICKS = DataWatcher.a(EntityPandaPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> SNEEZE_PROGRESS = DataWatcher.a(EntityPandaPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> EATING_TICKS = DataWatcher.a(EntityPandaPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> MAIN_GENE = DataWatcher.a(EntityPandaPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> HIDDEN_GENE = DataWatcher.a(EntityPandaPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> PANDA_FLAGS = DataWatcher.a(EntityPandaPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);

    public EntityPandaPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.aS, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("type", this.getGene().name());
        data.add("sitting", this.isSitting());
        data.add("sleeping", this.isLyingOnBack());
        data.add("sneeze", this.isSneezing());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(ASK_FOR_BAMBOO_TICKS, 0);
        dataAccess.define(SNEEZE_PROGRESS, 0);
        dataAccess.define(MAIN_GENE, (byte)0);
        dataAccess.define(HIDDEN_GENE, (byte)0);
        dataAccess.define(PANDA_FLAGS, (byte)0);
        dataAccess.define(EATING_TICKS, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("type", this.getGene());
        object.setBoolean("sitting", this.isSitting());
        object.setBoolean("sleeping", this.isLyingOnBack());
        object.setBoolean("sneeze", this.isSneezing());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("type")) {
            this.setGene(object.getEnum("type", PandaGene.class, PandaGene.NORMAL));
        }
        if (object.hasKey("sitting")) {
            this.setSitting(object.getBoolean("sitting", false));
        }
        if (object.hasKey("sleeping")) {
            this.setLyingOnBack(object.getBoolean("sleeping", false));
        }
        if (object.hasKey("sneeze")) {
            this.setSneezing(object.getBoolean("sneeze", false));
        }
        super.applyCompound(object);
    }

    @Override
    public PandaGene getGene() {
        return PandaGene.byId(((Byte)this.az.a(MAIN_GENE)).byteValue());
    }

    @Override
    public void setGene(PandaGene gene) {
        this.az.a(MAIN_GENE, (Object)((byte)gene.ordinal()));
        PandaGene hidden = PandaGene.byId(((Byte)this.az.a(HIDDEN_GENE)).byteValue());
        if (gene == PandaGene.BROWN || gene == PandaGene.WEAK) {
            this.az.a(HIDDEN_GENE, (Object)((byte)gene.ordinal()));
        } else if (hidden != PandaGene.BROWN && hidden != PandaGene.WEAK && hidden != PandaGene.NORMAL) {
            this.az.a(HIDDEN_GENE, (Object)0);
        }
    }

    @Override
    public void setSneezeProgress(int progress) {
        this.az.a(SNEEZE_PROGRESS, (Object)progress);
    }

    @Override
    public int getSneezeProgress() {
        return (Integer)this.az.a(SNEEZE_PROGRESS);
    }

    @Override
    public void setSpecialFlag(int flag, boolean value) {
        byte byte_1 = (Byte)this.az.a(PANDA_FLAGS);
        if (value) {
            this.az.a(PANDA_FLAGS, (Object)((byte)(byte_1 | flag)));
        } else {
            this.az.a(PANDA_FLAGS, (Object)((byte)(byte_1 & ~flag)));
        }
        this.getPetUser().updateDataMenu();
    }

    @Override
    public boolean getSpecialFlag(int flag) {
        return ((Byte)this.az.a(PANDA_FLAGS) & flag) != 0;
    }

    @Override
    public void g() {
        super.g();
        if (this.isSneezing()) {
            int progress = this.getSneezeProgress();
            this.setSneezeProgress(progress + 1);
            if (progress > 20) {
                this.setSneezing(false);
                this.handleSneeze();
            } else if (progress == 1) {
                this.a(SoundEffects.um, 1.0f, 1.0f);
            }
        }
    }

    private void handleSneeze() {
        Vec3D var0 = this.dI();
        double x = this.dK() - (double)(this.dA() + 1.0f) * 0.5 * (double)MathHelper.sin((double)(this.bB * ((float)Math.PI / 180)));
        double y = this.dM() + this.dO() - (double)0.1f;
        double z = this.dQ() + (double)(this.dB() + 1.0f) * 0.5 * (double)MathHelper.cos((double)(this.bB * ((float)Math.PI / 180)));
        this.an().a((ParticleParam)Particles.ak, x, y, z, var0.g, 0.0, var0.i);
        this.a(SoundEffects.un, 1.0f, 1.0f);
        List nearby = this.an().a(EntityPandaPet.class, this.de().g(10.0));
        nearby.forEach(panda -> {
            if (panda.bc && !panda.bu() && panda.isSpookedBySneeze()) {
                panda.u();
            }
        });
    }

    private boolean isSpookedBySneeze() {
        if (this.isLyingOnBack()) {
            return false;
        }
        return !this.isPlaying();
    }
}

