/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import simplepets.brainsynder.api.entity.passive.IEntityFrogPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.TemperatureVariant;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_10.helper.VersionHelper;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;
import simplepets.brainsynder.versions.v1_21_10.utils.VariantUtils;

@SupportedVersion(version=ServerVersion.v1_19)
public class EntityFrogPet
extends EntityAgeablePet
implements IEntityFrogPet {
    private static final DataWatcherObject<Holder<FrogVariant>> DATA_VARIANT = DataWatcher.a(EntityFrogPet.class, (DataWatcherSerializer)DataWatcherRegistry.B);
    private static final DataWatcherObject<OptionalInt> TONGUE_TARGET_ID = DataWatcher.a(EntityFrogPet.class, (DataWatcherSerializer)DataWatcherRegistry.u);
    private TemperatureVariant variant = TemperatureVariant.TEMPERATE;
    private boolean croaking = false;
    private int croakingTick = 0;
    private boolean tongue = false;
    private int tongueTick = 0;

    public EntityFrogPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ae, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("variant", this.getVariant().name());
        data.add("croaking", this.isCroaking());
        data.add("tongue", this.isUsingTongue());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DATA_VARIANT, VariantUtils.getDefaultOrAny(this.ej(), FrogVariants.a));
        dataAccess.define(TONGUE_TARGET_ID, OptionalInt.empty());
    }

    @Override
    public void g() {
        super.g();
        if (this.croaking) {
            if (this.croakingTick <= 0) {
                this.c(EntityPose.a);
                this.c(EntityPose.i);
                this.croakingTick = MathUtils.random(120, 150);
            }
            --this.croakingTick;
        }
        if (this.tongue) {
            if (this.tongueTick <= 0) {
                this.c(EntityPose.a);
                this.c(EntityPose.j);
                this.tongueTick = MathUtils.random(100, 150);
            }
            --this.tongueTick;
        }
        if (!this.isOnGround()) {
            this.c(EntityPose.g);
        } else {
            this.c(EntityPose.a);
        }
    }

    @Override
    public void m(Vec3D vec3d) {
        if (!this.isOwnerRiding() && this.bu()) {
            this.a(this.fD(), vec3d);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
        } else {
            super.m(vec3d);
        }
    }

    public void setTongueTarget(Entity entity) {
        this.az.a(TONGUE_TARGET_ID, (Object)OptionalInt.of(entity.az()));
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setEnum("variant", this.getVariant());
        compound.setBoolean("croaking", this.isCroaking());
        compound.setBoolean("tongue", this.isCroaking());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("variant")) {
            this.setVariant(object.getEnum("variant", TemperatureVariant.class, TemperatureVariant.TEMPERATE));
        }
        if (object.hasKey("croaking")) {
            this.setCroaking(object.getBoolean("croaking"));
        }
        if (object.hasKey("tongue")) {
            this.setUsingTongue(object.getBoolean("tongue"));
        }
        super.applyCompound(object);
    }

    @Override
    public void setVariant(TemperatureVariant variant) {
        this.variant = variant;
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.bb);
        this.az.a(DATA_VARIANT, (Object)registry.e((Object)((FrogVariant)VersionHelper.getRegistryValue(registry, variant.getKey()))));
    }

    @Override
    public TemperatureVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean isCroaking() {
        return this.croaking;
    }

    @Override
    public void setCroaking(boolean value) {
        this.croaking = value;
        if (this.croaking) {
            this.c(EntityPose.i);
        }
        if (!this.croaking) {
            this.c(EntityPose.a);
            this.croakingTick = 0;
        }
    }

    @Override
    public boolean isUsingTongue() {
        return this.tongue;
    }

    @Override
    public void setUsingTongue(boolean value) {
        this.tongue = value;
        if (this.tongue) {
            this.c(EntityPose.j);
        }
        if (!this.tongue) {
            this.c(EntityPose.a);
            this.tongueTick = 0;
        }
    }
}

