/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import simplepets.brainsynder.api.entity.passive.IEntityAxolotlPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.AxolotlVariant;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;

public class EntityAxolotlPet
extends EntityAgeablePet
implements IEntityAxolotlPet,
Bucketable {
    private static final DataWatcherObject<Integer> DATA_VARIANT = DataWatcher.a(EntityAxolotlPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> DATA_PLAYING_DEAD = DataWatcher.a(EntityAxolotlPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> FROM_BUCKET = DataWatcher.a(EntityAxolotlPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityAxolotlPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.j, type, user);
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DATA_VARIANT, 0);
        dataAccess.define(DATA_PLAYING_DEAD, false);
        dataAccess.define(FROM_BUCKET, false);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("variant", this.getVariant().name());
        data.add("playing-dead", this.isPlayingDead());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("variant", this.getVariant());
        object.setBoolean("playing_dead", this.isPlayingDead());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("variant")) {
            this.setVariant(object.getEnum("variant", AxolotlVariant.class, AxolotlVariant.LUCY));
        }
        if (object.hasKey("playing_dead")) {
            this.setPlayingDead(object.getBoolean("playing_dead", false));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isPlayingDead() {
        return (Boolean)this.az.a(DATA_PLAYING_DEAD);
    }

    @Override
    public void setPlayingDead(boolean playingDead) {
        this.az.a(DATA_PLAYING_DEAD, (Object)playingDead);
    }

    @Override
    public AxolotlVariant getVariant() {
        return AxolotlVariant.values()[(Integer)this.az.a(DATA_VARIANT)];
    }

    @Override
    public void setVariant(AxolotlVariant variant) {
        this.az.a(DATA_VARIANT, (Object)variant.ordinal());
    }

    public boolean m() {
        return (Boolean)this.az.a(FROM_BUCKET);
    }

    public void x(boolean b2) {
        this.az.a(FROM_BUCKET, (Object)b2);
    }

    public void a_(ItemStack itemStack) {
    }

    public void a(NBTTagCompound compoundTag) {
    }

    public ItemStack a() {
        return new ItemStack((IMaterial)Items.sl);
    }

    public SoundEffect n() {
        return SoundEffects.dm;
    }
}

