/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.Bukkit;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.utils.VersionFields;

public class CitizensFixer {
    private static final MethodHandles.Lookup METHOD_LOOKUP = MethodHandles.lookup();
    private static final Field MODIFIERS;
    private static final MethodHandle PUT_OBJECT;
    private static final MethodHandle STATIC_FIELD_OFFSET;
    private static RegistryBlocks<EntityTypes<?>> customRegistry;
    private static final boolean CITIZENS_FOUND;
    private static final ServerVersion SERVER_VERSION;

    public static void resetCustomRegistry() {
        if (!CITIZENS_FOUND) {
            return;
        }
        if (customRegistry == null) {
            return;
        }
        CitizensFixer.overrideRegistry(customRegistry);
    }

    public static void overrideRegistry(RegistryBlocks<EntityTypes<?>> entityRegistry) {
        if (!CITIZENS_FOUND) {
            return;
        }
        MethodHandle registrySetter = CitizensFixer.createStaticFinalSetter(BuiltInRegistries.class, VersionFields.fromServerVersion(SERVER_VERSION).getEntityRegistryField());
        try {
            registrySetter.invoke(entityRegistry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static RegistryBlocks<EntityTypes<?>> getVanillaRegistry(RegistryBlocks mappedRegistry) {
        if (!CITIZENS_FOUND) {
            return mappedRegistry;
        }
        if (!mappedRegistry.getClass().getName().equals(DefaultedMappedRegistry.class.getName())) {
            if (customRegistry == null) {
                customRegistry = mappedRegistry;
            }
            for (Field field : mappedRegistry.getClass().getDeclaredFields()) {
                if (field.getType() != DefaultedMappedRegistry.class && field.getType() != RegistryMaterials.class) continue;
                Reflection.setFieldAccessible(field);
                try {
                    RegistryBlocks<EntityTypes<?>> vanillaRegistry = (RegistryBlocks<EntityTypes<?>>)field.get(mappedRegistry);
                    if (!vanillaRegistry.getClass().getName().equals(DefaultedMappedRegistry.class.getName())) {
                        vanillaRegistry = CitizensFixer.getVanillaRegistry((RegistryBlocks)vanillaRegistry);
                    }
                    return vanillaRegistry;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to find vanilla registry", e);
                }
            }
        }
        return mappedRegistry;
    }

    public static MethodHandle createStaticFinalSetter(Class<?> className, String fieldName) {
        Field field = Reflection.getField(className, fieldName);
        if (field == null) {
            SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "Failed to find field: " + className.getName() + "$" + fieldName);
            return null;
        }
        if (MODIFIERS == null) {
            try {
                long offset = STATIC_FIELD_OFFSET.invoke(field);
                return MethodHandles.insertArguments(PUT_OBJECT, 0, className, offset);
            }
            catch (Throwable throwable) {
                SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "Failed to modify field: " + className.getName() + "$" + fieldName);
                throw new RuntimeException("Failed to modify field '" + fieldName + "' in the " + String.valueOf(className) + " class", throwable);
            }
        }
        try {
            MODIFIERS.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return METHOD_LOOKUP.unreflectSetter(field);
        }
        catch (Exception e) {
            SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "Failed to find field... Reason: " + e.getMessage());
            return null;
        }
    }

    public static MethodHandle getMethodHandle(Class<?> className, String method, Class<?> ... parameters) {
        if (className != null) {
            try {
                return METHOD_LOOKUP.unreflect(Reflection.getMethod(className, method, parameters));
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to lookup the method handler for the " + className.getName() + "." + method + " method", exception);
            }
        }
        return null;
    }

    static {
        customRegistry = null;
        CITIZENS_FOUND = Bukkit.getServer().getPluginManager().getPlugin("Citizens") != null;
        SERVER_VERSION = (ServerVersion)ServerVersion.getVersion();
        MODIFIERS = Reflection.getField(Field.class, "modifiers");
        try {
            Object UNSAFE = Reflection.getField(Class.forName("sun.misc.Unsafe"), "theUnsafe").get(null);
            STATIC_FIELD_OFFSET = CitizensFixer.getMethodHandle(UNSAFE.getClass(), "staticFieldOffset", Field.class).bindTo(UNSAFE);
            PUT_OBJECT = CitizensFixer.getMethodHandle(UNSAFE.getClass(), "putObject", Object.class, Long.TYPE, Object.class).bindTo(UNSAFE);
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

