/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.utils;

import java.util.HashMap;
import java.util.Map;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.utils.FieldValues;

public enum VersionFields implements FieldValues
{
    V1_21_11("e", "cj", "l", "m", "g", "bM", "X", "S", "cm", "d"),
    V1_21_9("e", "cf", "l", "m", "g", "bL", "X", "R", "cj", "d"),
    V1_21_6("e", "cc", "l", "m", "f", "bB", "W", "R", "cc", "f");

    private static final String MOJANG_ENTITY_DATA_MAP = "itemsById";
    private static final String MOJANG_ENTITY_FACTORY = "factory";
    private static final String MOJANG_REGISTRY_FROZEN = "frozen";
    private static final String MOJANG_REGISTRY_INTRUSIVE = "unregisteredIntrusiveHolders";
    private static final String MOJANG_ENTITY_REGISTRY = "ENTITY_TYPE";
    private static final String MOJANG_ENTITY_JUMP = "jumping";
    private static final String MOJANG_RIDE_COOLDOWN = "boardingCooldown";
    private static final String MOJANG_SERVER_RUNNING = "running";
    private static final String MOJANG_ATTRIBUTES = "attributes";
    private static final String MOJANG_TYPE = "type";
    private static final Map<ServerVersion, VersionFields> VERSION_MAP;
    private static final VersionFields CURRENT;
    private static final boolean MOJANG_MAPPED;
    private final FieldName entityDataMap;
    private final FieldName entityFactory;
    private final FieldName registryFrozen;
    private final FieldName registryIntrusive;
    private final FieldName entityRegistry;
    private final FieldName entityJump;
    private final FieldName resetCooldown;
    private final FieldName isRunning;
    private final FieldName attributes;
    private final FieldName type;

    private static Map<ServerVersion, VersionFields> buildVersionMap() {
        HashMap<ServerVersion, VersionFields> map = new HashMap<ServerVersion, VersionFields>();
        map.put(ServerVersion.v1_21_6, V1_21_6);
        map.put(ServerVersion.v1_21_7, V1_21_6);
        map.put(ServerVersion.v1_21_8, V1_21_6);
        map.put(ServerVersion.v1_21_9, V1_21_9);
        map.put(ServerVersion.v1_21_10, V1_21_9);
        map.put(ServerVersion.v1_21_11, V1_21_11);
        return map;
    }

    public static VersionFields fromServerVersion(ServerVersion version) {
        VersionFields fields = VERSION_MAP.get(version);
        if (fields == null) {
            throw new IllegalArgumentException("Unsupported server version: " + String.valueOf(version));
        }
        return fields;
    }

    private VersionFields(String entityDataMap, String entityFactory, String registryFrozen, String registryIntrusive, String entityRegistry, String entityJump, String resetCooldown, String isRunning, String attributes, String type) {
        this.entityDataMap = new FieldName(MOJANG_ENTITY_DATA_MAP, entityDataMap);
        this.entityFactory = new FieldName(MOJANG_ENTITY_FACTORY, entityFactory);
        this.registryFrozen = new FieldName(MOJANG_REGISTRY_FROZEN, registryFrozen);
        this.registryIntrusive = new FieldName(MOJANG_REGISTRY_INTRUSIVE, registryIntrusive);
        this.entityRegistry = new FieldName(MOJANG_ENTITY_REGISTRY, entityRegistry);
        this.entityJump = new FieldName(MOJANG_ENTITY_JUMP, entityJump);
        this.resetCooldown = new FieldName(MOJANG_RIDE_COOLDOWN, resetCooldown);
        this.isRunning = new FieldName(MOJANG_SERVER_RUNNING, isRunning);
        this.attributes = new FieldName(MOJANG_ATTRIBUTES, attributes);
        this.type = new FieldName(MOJANG_TYPE, type);
    }

    public static VersionFields current() {
        return CURRENT;
    }

    private String resolve(FieldName fieldName) {
        return MOJANG_MAPPED ? fieldName.mojangMapped() : fieldName.obfuscated();
    }

    @Override
    public String getEntityDataMapField() {
        return this.resolve(this.entityDataMap);
    }

    @Override
    public String getEntityFactoryField() {
        return this.resolve(this.entityFactory);
    }

    @Override
    public String getRegistryFrozenField() {
        return this.resolve(this.registryFrozen);
    }

    @Override
    public String getRegistryIntrusiveField() {
        return this.resolve(this.registryIntrusive);
    }

    @Override
    public String getEntityRegistryField() {
        return this.resolve(this.entityRegistry);
    }

    @Override
    public String getEntityJumpField() {
        return this.resolve(this.entityJump);
    }

    @Override
    public String getRideCooldownField() {
        return this.resolve(this.resetCooldown);
    }

    @Override
    public String getServerRunningField() {
        return this.resolve(this.isRunning);
    }

    public String getAttributesField() {
        return this.resolve(this.attributes);
    }

    public String getPacketEntityType() {
        return this.resolve(this.type);
    }

    static {
        VERSION_MAP = VersionFields.buildVersionMap();
        CURRENT = VersionFields.fromServerVersion((ServerVersion)ServerVersion.getVersion());
        MOJANG_MAPPED = PetCore.SERVER_INFORMATION.isMojangMapped();
    }

    public record FieldName(String mojangMapped, String obfuscated) {
    }
}

