/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.menu.inventory;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.api.event.inventory.PetInventoryAddPetItemEvent;
import simplepets.brainsynder.api.event.inventory.PetTypeStorage;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.storage.IStorage;
import simplepets.brainsynder.libs.bslib.storage.StorageList;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.libs.bslib.utils.ListPager;
import simplepets.brainsynder.managers.ItemManager;
import simplepets.brainsynder.menu.inventory.holders.SelectionHolder;
import simplepets.brainsynder.menu.items.list.Air;
import simplepets.brainsynder.utils.Utilities;

public class SelectionMenu
extends CustomInventory {
    private List<PetType> availableTypes;
    private Map<String, ListPager<PetTypeStorage>> pagerMap;
    private Map<String, IStorage<PetTypeStorage>> petMap;

    public SelectionMenu(File file) {
        super(file);
    }

    @Override
    public void loadDefaults() {
        this.availableTypes = new ArrayList<PetType>();
        this.pagerMap = new HashMap<String, ListPager<PetTypeStorage>>();
        this.petMap = new HashMap<String, IStorage<PetTypeStorage>>();
        this.setDefault("size", 54);
        this.setDefault("title_comment", "The title of the GUI can support regular color codes '&c' and HEX color codes '&#FFFFFF'");
        this.setDefault("title", "&#de9790[] &#b35349Pets");
        HashMap<Integer, String> object = new HashMap<Integer, String>();
        Arrays.asList(11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44).forEach(slot -> object.put((Integer)slot, "air"));
        object.put(4, "saves");
        object.put(6, "name");
        object.put(9, "data");
        object.put(46, "previouspage");
        object.put(49, "ride");
        object.put(50, "remove");
        object.put(51, "hat");
        object.put(54, "nextpage");
        Set set = object.entrySet();
        ArrayList list = new ArrayList(set);
        list.sort(Map.Entry.comparingByKey());
        JsonArray array = new JsonArray();
        for (Map.Entry entry : list) {
            JsonObject json = new JsonObject();
            json.add("slot", (Integer)entry.getKey());
            json.add("item", (String)entry.getValue());
            array.add(json);
        }
        this.setDefault("slots", array);
        for (PetType type : PetType.values()) {
            IPetConfig config;
            Optional<IPetConfig> optional;
            if (!type.isSupported() || type.isInDevelopment() && !ConfigOption.INSTANCE.PET_TOGGLES_DEV_MOBS.getValue().booleanValue() || !(optional = SimplePets.getPetConfigManager().getPetConfig(type)).isPresent() || !(config = optional.get()).isEnabled() || !SimplePets.getSpawnUtil().isRegistered(type)) continue;
            this.availableTypes.add(type);
        }
    }

    @Override
    public void onClick(int slot, ItemStack item, Player player) {
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.SUMMON_GUI;
    }

    public void reloadAvailableTypes() {
        this.availableTypes.clear();
        for (PetType type : PetType.values()) {
            IPetConfig config;
            Optional<IPetConfig> optional;
            if (!type.isSupported() || !(optional = SimplePets.getPetConfigManager().getPetConfig(type)).isPresent() || !(config = optional.get()).isEnabled() || !SimplePets.getSpawnUtil().isRegistered(type)) continue;
            this.availableTypes.add(type);
        }
    }

    @Override
    public void open(PetUser user, int page) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = user.getPlayer();
        this.pageSave.put(player.getName(), page);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new SelectionHolder(), (int)this.getInteger("size", 54), (String)Colorize.translateBungeeHex(this.getString("title", "&#de9790[] &#b35349Pets")));
        int maxPets = 0;
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            int slot2 = placeHolder - 1;
            if (this.getSlots().containsKey(slot2)) {
                Item item2 = this.getSlots().get(slot2);
                if (item2 instanceof Air) {
                    ++maxPets;
                    continue;
                }
                inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
                continue;
            }
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        boolean removeNoPerms = ConfigOption.INSTANCE.PERMISSIONS_PLAYER_ACCESS.getValue();
        StorageList<PetTypeStorage> petTypes = new StorageList<PetTypeStorage>();
        for (PetType type : this.availableTypes) {
            PetTypeStorage storage = new PetTypeStorage(type);
            PetInventoryAddPetItemEvent event = new PetInventoryAddPetItemEvent(this, user, storage.getType(), storage.getItem());
            if (Utilities.hasPermission((CommandSender)player, type.getPermission()) || user.getOwnedPets().contains((Object)type) && ConfigOption.INSTANCE.UTILIZE_PURCHASED_PETS.getValue().booleanValue()) {
                Bukkit.getPluginManager().callEvent((Event)event);
            } else {
                if (removeNoPerms) continue;
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) continue;
            petTypes.add(storage.setItem(event.getItem()));
        }
        if (petTypes.getSize() == 0 && ConfigOption.INSTANCE.PERMISSIONS_OPEN_GUI.getValue().booleanValue()) {
            player.sendMessage(MessageFile.getTranslation(MessageOption.NO_PETS_UNLOCKED));
            return;
        }
        ListPager pages = new ListPager(maxPets, petTypes.toArrayList());
        this.pagerMap.put(player.getName(), pages);
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        if (!pages.isEmpty()) {
            if (pages.exists(page)) {
                for (PetTypeStorage storage : pages.getPage(page)) {
                    inv.addItem(new ItemStack[]{storage.getItem()});
                }
                this.petMap.put(player.getName(), new StorageList(pages.getPage(page)));
            } else {
                SimplePets.getDebugLogger().debug(DebugLevel.WARNING, "Page does not exist (Page " + page + " / " + pages.totalPages() + ")");
            }
        }
        if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
            inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        player.openInventory(inv);
    }

    @Override
    public void update(PetUser user) {
        if (!this.isEnabled()) {
            return;
        }
        if (user == null) {
            return;
        }
        Player player = user.getPlayer();
        if (!this.pageSave.containsKey(player.getName())) {
            return;
        }
        int page = this.pageSave.getOrDefault(player.getName(), 1);
        Inventory inv = player.getOpenInventory().getTopInventory();
        if (inv.getHolder() == null) {
            return;
        }
        if (!(inv.getHolder() instanceof SelectionHolder)) {
            return;
        }
        int maxPets = 0;
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            int slot2 = placeHolder - 1;
            if (this.getSlots().containsKey(slot2)) {
                Item item2 = this.getSlots().get(slot2);
                if (item2 instanceof Air) {
                    ++maxPets;
                    continue;
                }
                inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
                continue;
            }
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        boolean removeNoPerms = ConfigOption.INSTANCE.PERMISSIONS_PLAYER_ACCESS.getValue();
        StorageList<PetTypeStorage> petTypes = new StorageList<PetTypeStorage>();
        for (PetType type : this.availableTypes) {
            PetTypeStorage storage = new PetTypeStorage(type);
            PetInventoryAddPetItemEvent event = new PetInventoryAddPetItemEvent(this, user, storage.getType(), storage.getItem());
            if (Utilities.hasPermission((CommandSender)player, type.getPermission()) || user.getOwnedPets().contains((Object)type) && ConfigOption.INSTANCE.UTILIZE_PURCHASED_PETS.getValue().booleanValue()) {
                Bukkit.getPluginManager().callEvent((Event)event);
            } else {
                if (removeNoPerms) continue;
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) continue;
            petTypes.add(storage.setItem(event.getItem()));
        }
        if (petTypes.getSize() == 0 && ConfigOption.INSTANCE.PERMISSIONS_OPEN_GUI.getValue().booleanValue()) {
            player.sendMessage(MessageFile.getTranslation(MessageOption.NO_PETS_UNLOCKED));
            return;
        }
        ListPager pages = new ListPager(maxPets, petTypes.toArrayList());
        this.pagerMap.put(player.getName(), pages);
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        if (!pages.isEmpty()) {
            if (pages.exists(page)) {
                for (PetTypeStorage storage : pages.getPage(page)) {
                    inv.addItem(new ItemStack[]{storage.getItem()});
                }
                this.petMap.put(player.getName(), new StorageList(pages.getPage(page)));
            } else {
                SimplePets.getDebugLogger().debug(DebugLevel.WARNING, "Page does not exist (Page " + page + " / " + pages.totalPages() + ")");
            }
        }
    }

    public Map<String, IStorage<PetTypeStorage>> getPetMap() {
        return this.petMap;
    }

    public ListPager<PetTypeStorage> getPages(PetUser user) {
        Player player = user.getPlayer();
        if (this.pagerMap.containsKey(player.getName())) {
            return this.pagerMap.get(player.getName());
        }
        return null;
    }

    @Override
    public void reset(PetUser user) {
        super.reset(user);
        String name = user.getOwnerName();
        this.petMap.remove(name);
        this.pagerMap.remove(name);
    }
}

