/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.menu.inventory;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.managers.ItemManager;
import simplepets.brainsynder.menu.inventory.holders.PetDataHolder;

public class DataMenu
extends CustomInventory {
    private Map<String, PetType> typeMap;

    public DataMenu(File file) {
        super(file);
    }

    @Override
    public void loadDefaults() {
        this.typeMap = new HashMap<String, PetType>();
        this.setDefault("size", 54);
        this.setDefault("title_comment", "The title of the GUI can support regular color codes '&c' and HEX color codes '&#FFFFFF'");
        this.setDefault("title", "&#de9790[] &#b35349Pet Data Changer");
        HashMap<Integer, String> object = new HashMap<Integer, String>();
        Arrays.asList(20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35).forEach(slot -> object.put((Integer)slot, "air"));
        object.put(1, "storage");
        object.put(5, "name");
        object.put(49, "ride");
        object.put(50, "remove");
        object.put(51, "hat");
        Set set = object.entrySet();
        ArrayList list = new ArrayList(set);
        list.sort(Map.Entry.comparingByKey());
        JsonArray array = new JsonArray();
        for (Map.Entry entry : list) {
            JsonObject json = new JsonObject();
            json.add("slot", (Integer)entry.getKey());
            json.add("item", (String)entry.getValue());
            array.add(json);
        }
        this.setDefault("slots", array);
    }

    @Override
    public void onClick(int slot, ItemStack item, Player player) {
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.DATA_GUI;
    }

    public PetType getType(Player player) {
        return this.typeMap.getOrDefault(player.getName(), PetType.UNKNOWN);
    }

    public void setType(Player player, PetType type) {
        if (type == null || type == PetType.UNKNOWN) {
            this.typeMap.remove(player.getName());
        } else {
            this.typeMap.put(player.getName(), type);
        }
    }

    @Override
    public void open(PetUser user, int page) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = user.getPlayer();
        PetType type = this.typeMap.getOrDefault(player.getName(), PetType.UNKNOWN);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new PetDataHolder(), (int)this.getInteger("size", 54), (String)Colorize.translateBungeeHex(this.getString("title", "&#de9790[] &#b35349Pet Data Changer")));
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        if (user.hasPet(type)) {
            user.getPetEntity(type).ifPresent(entityPet -> this.addPetData(inv, (IEntityPet)entityPet));
        }
        if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
            inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        player.openInventory(inv);
        this.setType(player, type);
    }

    @Override
    public void update(PetUser user) {
        if (!this.isEnabled()) {
            return;
        }
        if (user == null) {
            return;
        }
        Player player = user.getPlayer();
        if (player == null) {
            return;
        }
        if (!user.hasPets()) {
            player.closeInventory();
            return;
        }
        Inventory inv = player.getOpenInventory().getTopInventory();
        if (inv.getHolder() == null) {
            return;
        }
        if (!(inv.getHolder() instanceof PetDataHolder)) {
            return;
        }
        PetType type = this.typeMap.getOrDefault(player.getName(), PetType.UNKNOWN);
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        if (!user.hasPet(type)) {
            player.closeInventory();
            return;
        }
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        user.getPetEntity(type).ifPresent(entityPet -> this.addPetData(inv, (IEntityPet)entityPet));
        if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
            inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
    }

    private void addPetData(Inventory inv, IEntityPet entityPet) {
        PetType type = entityPet.getPetType();
        IEntityPet pet = entityPet;
        if (entityPet instanceof IEntityControllerPet) {
            pet = ((IEntityControllerPet)entityPet).getVisibleEntity();
        }
        IEntityPet finalPet = pet;
        type.getPetData().forEach(petData -> {
            if (!petData.isEnabled(finalPet)) {
                return;
            }
            if (ConfigOption.INSTANCE.PERMISSIONS_DATA_PERMS.getValue().booleanValue() && !entityPet.getPetUser().getPlayer().hasPermission(type.getPermission("data." + petData.getNamespace().namespace()))) {
                return;
            }
            if (!petData.isModifiable(finalPet)) {
                return;
            }
            petData.getItem(finalPet).ifPresent(o -> inv.addItem(new ItemStack[]{((ItemBuilder)o).build()}));
        });
    }

    @Override
    public void reset(PetUser user) {
        super.reset(user);
        this.typeMap.remove(user.getOwnerName());
    }
}

