/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.menu.inventory;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.addon.AddonCloudData;
import simplepets.brainsynder.addon.PetModule;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.libs.bslib.utils.ListPager;
import simplepets.brainsynder.managers.AddonManager;
import simplepets.brainsynder.managers.ItemManager;
import simplepets.brainsynder.menu.inventory.holders.AddonHolder;
import simplepets.brainsynder.menu.items.list.Air;
import simplepets.brainsynder.utils.Keys;

public class AddonMenu
extends CustomInventory {
    private Map<String, List<AddonCloudData>> addonCache;
    private Map<String, ListPager<ItemBuilder>> pagerMap;
    private Map<String, Boolean> installerMap;

    public AddonMenu(File file) {
        super(file);
    }

    @Override
    public void loadDefaults() {
        this.addonCache = new HashMap<String, List<AddonCloudData>>();
        this.pagerMap = new HashMap<String, ListPager<ItemBuilder>>();
        this.installerMap = new HashMap<String, Boolean>();
        this.setDefault("_COMMENT_", "This menu is only viewed by people who have permission to it (Not recommended for regular users to have access to)");
        this.setDefault("size", 54);
        this.setDefault("title_comment", "The title of the GUI can support regular color codes '&c' and HEX color codes '&#FFFFFF'");
        this.setDefault("title", "&#de9790[] &#b35349SimplePets Addon Modules");
        HashMap<Integer, String> object = new HashMap<Integer, String>();
        Arrays.asList(11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44).forEach(slot -> object.put((Integer)slot, "air"));
        object.put(46, "previouspage");
        object.put(50, "installer");
        object.put(54, "nextpage");
        Set set = object.entrySet();
        ArrayList list = new ArrayList(set);
        list.sort(Map.Entry.comparingByKey());
        JsonArray array = new JsonArray();
        for (Map.Entry entry : list) {
            JsonObject json = new JsonObject();
            json.add("slot", (Integer)entry.getKey());
            json.add("item", (String)entry.getValue());
            array.add(json);
        }
        this.setDefault("slots", array);
    }

    @Override
    public void onClick(int slot, ItemStack item, Player player) {
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.ADDON_GUI;
    }

    public boolean isInstallerGUI(PetUser user) {
        return this.installerMap.getOrDefault(user.getPlayer().getName(), false);
    }

    public void open(PetUser user, int page, boolean installer) {
        Player player = user.getPlayer();
        this.installerMap.put(player.getName(), installer);
        this.pageSave.put(player.getName(), page);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new AddonHolder(), (int)this.getInteger("size", 54), (String)Colorize.translateBungeeHex(this.getString("title", "&#de9790[] &#b35349SimplePets Addon Modules")));
        int maxPets = 0;
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            int slot2 = placeHolder - 1;
            if (this.getSlots().containsKey(slot2)) {
                Item item2 = this.getSlots().get(slot2);
                if (item2 instanceof Air) {
                    ++maxPets;
                    continue;
                }
                inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
                continue;
            }
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        ItemBuilder master = new ItemBuilder(Material.PLAYER_HEAD).setTexture("http://textures.minecraft.net/texture/ce1f3cc63c73a6a1dde72fe09c6ac5569376d7b61231bb740764368788cbf1fa");
        int finalMaxPets = maxPets;
        if (!installer) {
            ArrayList items = Lists.newArrayList();
            AddonManager manager = PetCore.getInstance().getAddonManager();
            for (PetModule module : manager.getLoadedAddons()) {
                String name = module.getNamespace().namespace();
                ItemBuilder builder = ItemBuilder.fromItem(module.getAddonIcon());
                builder.addLore("&r ", "&7Enabled: " + (module.isEnabled() ? "&atrue" : "&cfalse"));
                builder.handleMeta(ItemMeta.class, itemMeta -> {
                    PersistentDataContainer container = itemMeta.getPersistentDataContainer();
                    container.set(Keys.MODULE_NAME, PersistentDataType.STRING, (Object)name);
                    container.set(Keys.ADDON_NAME, PersistentDataType.STRING, (Object)module.getLocalData().getName());
                    return itemMeta;
                });
                items.add(builder);
            }
            ListPager pages = new ListPager(finalMaxPets, items);
            this.pagerMap.put(player.getName(), pages);
            if (!pages.isEmpty()) {
                if (pages.exists(page)) {
                    pages.getPage(page).forEach(builder1 -> inv.addItem(new ItemStack[]{builder1.build()}));
                } else {
                    SimplePets.getDebugLogger().debug(DebugLevel.WARNING, "Page does not exist (Page " + page + " / " + pages.totalPages() + ")");
                }
            }
            if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
                inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
            }
            player.openInventory(inv);
            return;
        }
        this.handleFetch(player.getName(), addons -> {
            ArrayList items = Lists.newArrayList();
            AddonManager manager = PetCore.getInstance().getAddonManager();
            for (AddonCloudData data : addons) {
                String name = data.getName();
                if (manager.fetchAddon(name).isPresent()) continue;
                ItemBuilder builder = master.clone();
                builder.withName(String.valueOf(Colorize.fetchColor("e1eb5b")) + name);
                ArrayList description = Lists.newArrayList();
                if (!data.getDescription().isEmpty()) {
                    data.getDescription().forEach(s -> description.add(String.valueOf(ChatColor.GRAY) + s));
                }
                description.add("&r ");
                description.add("&7Modrinth ID: &e" + data.getId());
                description.add("&7Author: &e" + data.getAuthor());
                description.add("&7Version: &e" + data.getVersion());
                description.add("&7Last Update: &e" + data.getLastUpdated());
                description.add("&7Total Downloads: &e" + data.getDownloadCount());
                builder.withLore(description).addLore("&r ", "&7Click here to install the", "&7" + name + " addon to your server");
                builder.handleMeta(ItemMeta.class, itemMeta -> {
                    PersistentDataContainer container = itemMeta.getPersistentDataContainer();
                    container.set(Keys.ADDON_URL, PersistentDataType.STRING, (Object)data.getDownloadURL());
                    container.set(Keys.ADDON_NAME, PersistentDataType.STRING, (Object)name);
                    return itemMeta;
                });
                items.add(builder);
            }
            ListPager pages = new ListPager(finalMaxPets, items);
            this.pagerMap.put(player.getName(), pages);
            if (!pages.isEmpty()) {
                if (pages.exists(page)) {
                    pages.getPage(page).forEach(builder1 -> inv.addItem(new ItemStack[]{builder1.build()}));
                } else {
                    SimplePets.getDebugLogger().debug(DebugLevel.WARNING, "Page does not exist (Page " + page + " / " + pages.totalPages() + ")");
                }
            }
            if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
                inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
            }
            player.openInventory(inv);
        });
    }

    @Override
    public void open(PetUser user, int page) {
        this.open(user, page, false);
    }

    public void handleFetch(String name, Consumer<List<AddonCloudData>> consumer) {
        if (this.addonCache.containsKey(name)) {
            consumer.accept(this.addonCache.get(name));
            return;
        }
        PetCore.getInstance().getAddonManager().fetchAddons(jsonValues -> {
            this.addonCache.put(name, (List<AddonCloudData>)jsonValues);
            consumer.accept((List<AddonCloudData>)jsonValues);
        });
    }

    public ListPager<ItemBuilder> getPages(PetUser user) {
        Player player = user.getPlayer();
        if (this.pagerMap.containsKey(player.getName())) {
            return this.pagerMap.get(player.getName());
        }
        return null;
    }

    @Override
    public void reset(PetUser user) {
        super.reset(user);
        String name = user.getOwnerName();
        this.installerMap.remove(name);
        this.addonCache.remove(name);
        this.pagerMap.remove(name);
    }
}

