/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.user.UserManagement;
import simplepets.brainsynder.impl.PetOwner;

public class UserManager
implements UserManagement {
    private final Map<UUID, PetUser> userMap;
    private final Map<String, UUID> uuidCache;
    private final PetCore PLUGIN;

    public UserManager(PetCore plugin) {
        this.PLUGIN = plugin;
        this.userMap = new HashMap<UUID, PetUser>();
        this.uuidCache = new HashMap<String, UUID>();
    }

    @Override
    public void getPetUser(String username, Consumer<Optional<PetUser>> consumer) {
        if (this.uuidCache.containsKey(username)) {
            consumer.accept(this.getPetUser(this.uuidCache.get(username)));
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)username);
        if (offlinePlayer.hasPlayedBefore() || offlinePlayer.isOnline()) {
            UUID uuid = offlinePlayer.getUniqueId();
            this.uuidCache.put(username, uuid);
            consumer.accept(this.getPetUser(uuid));
            return;
        }
        consumer.accept(Optional.empty());
    }

    @Override
    public Optional<PetUser> getPetUser(UUID uuid) {
        return this.getPetUser(Bukkit.getPlayer((UUID)uuid));
    }

    @Override
    public Optional<PetUser> getPetUser(Player player) {
        PetUser user;
        if (player == null) {
            return Optional.empty();
        }
        if (this.userMap.containsKey(player.getUniqueId())) {
            user = this.userMap.get(player.getUniqueId());
        } else {
            user = new PetOwner(player);
            this.userMap.put(player.getUniqueId(), user);
        }
        return Optional.of(user);
    }

    @Override
    public Collection<PetUser> getAllUsers() {
        return this.userMap.values();
    }

    @Override
    public boolean isUserCached(Player player) {
        return this.userMap.containsKey(player.getUniqueId());
    }
}

