/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.managers;

import java.io.File;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.libs.bslib.files.JsonFile;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagTools;
import simplepets.brainsynder.libs.bslib.particle.Particle;
import simplepets.brainsynder.libs.bslib.particle.ParticleMaker;

public class ParticleManager
implements ParticleHandler {
    private File folder;
    private ParticleMaker spawnParticle;
    private ParticleMaker renameParticle;
    private ParticleMaker failSpawnParticle;
    private ParticleMaker removeParticle;
    private ParticleMaker teleportParticle;
    private ParticleMaker taskFailParticle;

    public ParticleManager(PetCore plugin) {
        this.reload(plugin);
    }

    public void reload(PetCore plugin) {
        this.folder = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Particles");
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        this.spawnParticle = this.getCustomizedParticle(new ParticleMaker(Particle.INSTANT_EFFECT, 15, 1.3), "SpawnParticle");
        this.failSpawnParticle = this.getCustomizedParticle(new ParticleMaker(Particle.ASH, 10, 1.3), "FailedSpawnParticle");
        this.taskFailParticle = this.getCustomizedParticle(new ParticleMaker(Particle.SMOKE, 10, 1.3), "FailedTaskParticle");
        this.renameParticle = this.getCustomizedParticle(new ParticleMaker(Particle.HAPPY_VILLAGER, 10, 1.3), "RenameParticle");
        this.removeParticle = this.getCustomizedParticle(new ParticleMaker(Particle.LAVA, 20, 1.0), "RemoveParticle");
        this.teleportParticle = this.getCustomizedParticle(new ParticleMaker(Particle.PORTAL, 20, 1.0, 0.3, 1.0), "TeleportParticle");
    }

    private ParticleMaker getCustomizedParticle(final ParticleMaker defaultParticle, String name) {
        try {
            JsonFile file = new JsonFile(this, new File(this.folder, name + ".json")){

                @Override
                public void loadDefaults() {
                    this.setDefault("particle", StorageTagTools.toJsonObject(defaultParticle.toCompound()));
                }
            };
            if (!file.hasKey("particle")) {
                return defaultParticle;
            }
            return new ParticleMaker(StorageTagTools.fromJsonObject((JsonObject)file.getValue("particle")));
        }
        catch (Exception e) {
            return defaultParticle;
        }
    }

    @Override
    public void sendParticle(ParticleHandler.Reason reason, Player player, Location location) {
        if (player == null) {
            return;
        }
        switch (reason) {
            case SPAWN: {
                if (!ConfigOption.INSTANCE.PARTICLES_SUMMON_TOGGLE.getValue().booleanValue()) break;
                this.spawnParticle.sendToPlayer(player, location);
                break;
            }
            case FAILED: {
                if (!ConfigOption.INSTANCE.PARTICLES_FAILED_TOGGLE.getValue().booleanValue()) break;
                this.failSpawnParticle.sendToPlayer(player, location);
                break;
            }
            case RENAME: {
                if (!ConfigOption.INSTANCE.PARTICLES_RENAME_TOGGLE.getValue().booleanValue()) break;
                this.renameParticle.sendToPlayer(player, location);
                break;
            }
            case REMOVE: {
                if (!ConfigOption.INSTANCE.PARTICLES_REMOVE_TOGGLE.getValue().booleanValue()) break;
                this.removeParticle.sendToPlayer(player, location);
                break;
            }
            case TELEPORT: {
                if (!ConfigOption.INSTANCE.PARTICLES_TELEPORT_TOGGLE.getValue().booleanValue()) break;
                this.teleportParticle.sendToPlayer(player, location);
                break;
            }
            case TASK_FAILED: {
                if (!ConfigOption.INSTANCE.PARTICLES_FAILED_TASK_TOGGLE.getValue().booleanValue()) break;
                this.taskFailParticle.sendToPlayer(player, location);
            }
        }
    }

    public ParticleMaker getTaskFailParticle() {
        return this.taskFailParticle;
    }

    public ParticleMaker getTeleportParticle() {
        return this.teleportParticle;
    }

    public ParticleMaker getFailSpawnParticle() {
        return this.failSpawnParticle;
    }

    public ParticleMaker getRenameParticle() {
        return this.renameParticle;
    }

    public ParticleMaker getSpawnParticle() {
        return this.spawnParticle;
    }

    public ParticleMaker getRemoveParticle() {
        return this.removeParticle;
    }
}

