/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.managers;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.Namespace;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.inventory.handler.ItemHandler;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.utils.TaskTimer;
import simplepets.brainsynder.menu.items.CustomItem;
import simplepets.brainsynder.menu.items.list.Air;
import simplepets.brainsynder.menu.items.list.Hat;
import simplepets.brainsynder.menu.items.list.Installer;
import simplepets.brainsynder.menu.items.list.Name;
import simplepets.brainsynder.menu.items.list.NextPage;
import simplepets.brainsynder.menu.items.list.Placeholder;
import simplepets.brainsynder.menu.items.list.PreviousPage;
import simplepets.brainsynder.menu.items.list.Remove;
import simplepets.brainsynder.menu.items.list.Ride;
import simplepets.brainsynder.menu.items.list.SavePet;
import simplepets.brainsynder.menu.items.list.Saves;

public class ItemManager
implements ItemHandler {
    private File registeredFolder;
    private static Air AIR;
    public static Placeholder PLACEHOLDER;
    private PetCore plugin;
    private final Map<String, Item> items = new HashMap<String, Item>();

    public void initiate() {
        TaskTimer timer = new TaskTimer(this.getClass(), "initiate");
        timer.start();
        this.plugin = PetCore.getInstance();
        SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setMessages("Initializing Menu Items..."));
        if (this.items != null && !this.items.isEmpty()) {
            this.items.clear();
        }
        timer.label("clearing old data (if any)");
        SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setMessages("Loading Customizable Item Files..."));
        File customFolder = new File(String.valueOf(this.plugin.getDataFolder()) + "/Items/Custom/");
        this.registeredFolder = new File(String.valueOf(this.plugin.getDataFolder()) + "/Items/AddonItems/");
        if (!customFolder.exists()) {
            customFolder.mkdirs();
        }
        if (!this.registeredFolder.exists()) {
            this.registeredFolder.mkdirs();
        }
        timer.label("folder generation");
        this.add(new Air(ItemManager.getLocation(this.plugin, Air.class)));
        this.add(new Hat(ItemManager.getLocation(this.plugin, Hat.class)));
        this.add(new Name(ItemManager.getLocation(this.plugin, Name.class)));
        this.add(new NextPage(ItemManager.getLocation(this.plugin, NextPage.class)));
        this.add(new PreviousPage(ItemManager.getLocation(this.plugin, PreviousPage.class)));
        this.add(new Remove(ItemManager.getLocation(this.plugin, Remove.class)));
        this.add(new Installer(ItemManager.getLocation(this.plugin, Installer.class)));
        this.add(new Ride(ItemManager.getLocation(this.plugin, Ride.class)));
        this.add(new Placeholder(ItemManager.getLocation(this.plugin, Placeholder.class)));
        this.add(new SavePet(ItemManager.getLocation(this.plugin, SavePet.class)));
        this.add(new Saves(ItemManager.getLocation(this.plugin, Saves.class)));
        timer.label("items registered");
        for (Item loader : this.items.values()) {
            loader.save();
        }
        timer.label("saving files");
        SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setMessages("Files have been loaded."));
        List<File> files = Arrays.asList(customFolder.listFiles());
        if (!files.isEmpty()) {
            for (File file : files) {
                CustomItem item;
                if (!file.getName().endsWith(".json") || !(item = new CustomItem(this, file){

                    @Override
                    public ItemBuilder getDefaultItem() {
                        return new ItemBuilder(Material.STONE);
                    }
                }).hasKey("namespace") || !item.isEnabled()) continue;
                this.items.putIfAbsent(item.getString("namespace"), item);
            }
        }
        timer.label("fetched custom items");
        AIR = this.getItem(Air.class).get();
        PLACEHOLDER = this.getItem(Placeholder.class).get();
        timer.stop();
    }

    public static File getLocation(PetCore core, Class<? extends Item> clazz) {
        File folder = new File(String.valueOf(core.getDataFolder()) + "/Items/");
        return new File(folder, clazz.getSimpleName() + ".json");
    }

    private void add(Item item) {
        item.getItemData().ifPresent(itemData -> this.items.putIfAbsent(itemData.namespace(), item));
    }

    public void reloadLoaders() {
        this.items.clear();
        this.initiate();
    }

    @Override
    public boolean register(Class<? extends Item> clazz) {
        Item item;
        if (!clazz.isAnnotationPresent(Namespace.class)) {
            throw new MissingResourceException("Missing ItemData annotation", clazz.getName(), "@ItemData");
        }
        Namespace data = clazz.getAnnotation(Namespace.class);
        String name = data.namespace();
        try {
            Constructor<? extends Item> constructor = clazz.getConstructor(File.class);
            item = constructor.newInstance(new File(this.registeredFolder, name + ".json"));
        }
        catch (Exception e) {
            return false;
        }
        if (this.items.containsKey(name)) {
            return false;
        }
        item.save();
        this.items.put(name, item);
        return true;
    }

    @Override
    public <T extends Item> Optional<T> getItem(Class<T> clazz) {
        if (this.items == null) {
            this.initiate();
        }
        if (this.items.isEmpty()) {
            this.initiate();
        }
        for (Item loader : this.items.values()) {
            if (!clazz.isAssignableFrom(loader.getClass())) continue;
            return Optional.of(loader);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Item> getItem(String namespace) {
        if (this.items == null) {
            this.initiate();
        }
        if (this.items.isEmpty()) {
            this.initiate();
        }
        if (namespace.equalsIgnoreCase("air")) {
            return Optional.of(AIR);
        }
        if (this.items.containsKey(namespace)) {
            return Optional.of(this.items.get(namespace));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Item> getItem(ItemStack item) {
        if (this.items == null) {
            this.initiate();
        }
        if (this.items.isEmpty()) {
            this.initiate();
        }
        if (item.getType() == Material.AIR) {
            return Optional.of(AIR);
        }
        for (Item loader : this.items.values()) {
            if (!loader.getItemBuilder().isSimilar(item)) continue;
            return Optional.of(loader);
        }
        return Optional.empty();
    }
}

