/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.listeners;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.event.inventory.PetSelectTypeEvent;
import simplepets.brainsynder.api.event.inventory.PetTypeStorage;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.storage.IStorage;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.menu.inventory.SelectionMenu;
import simplepets.brainsynder.menu.inventory.holders.SelectionHolder;
import simplepets.brainsynder.utils.Utilities;

public class SelectionGUIListener
implements Listener {
    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof SelectionHolder)) {
            return;
        }
        SelectionMenu menu = InventoryManager.SELECTION;
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            if (e.getCurrentItem() == null) {
                return;
            }
            SimplePets.getUserManager().getPetUser(player).ifPresent(user -> {
                Optional<Item> optionalItem = SimplePets.getItemHandler().getItem(e.getCurrentItem());
                if (optionalItem.isPresent()) {
                    if (e.getClick().isShiftClick()) {
                        optionalItem.get().onShiftClick((PetUser)user, menu);
                        return;
                    }
                    optionalItem.get().onClick((PetUser)user, menu);
                    return;
                }
                if (!menu.getPetMap().containsKey(player.getName())) {
                    e.setCancelled(true);
                    player.closeInventory();
                    return;
                }
                IStorage<PetTypeStorage> storage = menu.getPetMap().get(player.getName()).copy();
                while (storage.hasNext()) {
                    PetTypeStorage type = storage.next();
                    if (!ItemBuilder.fromItem(type.getItem()).isSimilar(e.getCurrentItem())) continue;
                    PetSelectTypeEvent event = new PetSelectTypeEvent(type.getType(), (PetUser)user);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    if (!user.canSpawnMorePets()) {
                        e.setCancelled(true);
                        player.closeInventory();
                        player.sendMessage(MessageFile.getTranslation(MessageOption.CANT_SPAWN_MORE_PETS));
                        return;
                    }
                    new BukkitRunnable(this, (PetUser)user, type){
                        final /* synthetic */ PetUser val$user;
                        final /* synthetic */ PetTypeStorage val$type;
                        {
                            this.val$user = petUser;
                            this.val$type = petTypeStorage;
                        }

                        public void run() {
                            Utilities.handlePetSpawning(this.val$user, this.val$type.getType(), new StorageTagCompound(), false);
                        }
                    }.runTask((Plugin)PetCore.getInstance());
                    break;
                }
            });
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof SelectionHolder)) {
            return;
        }
        SelectionMenu menu = InventoryManager.SELECTION;
        Bukkit.getScheduler().runTaskLater((Plugin)PetCore.getInstance(), () -> {
            if (!(e.getPlayer().getOpenInventory().getTopInventory().getHolder() instanceof SelectionHolder)) {
                SimplePets.getUserManager().getPetUser((Player)e.getPlayer()).ifPresent(menu::reset);
            }
        }, 3L);
    }
}

