/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.listeners;

import java.util.Optional;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.menu.inventory.DataMenu;
import simplepets.brainsynder.menu.inventory.holders.PetDataHolder;
import simplepets.brainsynder.utils.Utilities;

public class DataGUIListener
implements Listener {
    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof PetDataHolder)) {
            return;
        }
        DataMenu menu = InventoryManager.PET_DATA;
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            SimplePets.getUserManager().getPetUser(player).ifPresent(user -> {
                if (e.getCurrentItem() == null) {
                    return;
                }
                PetType type = menu.getType(player);
                user.getPetEntity(type).ifPresent(entityPet -> {
                    Optional<Item> optionalItem = SimplePets.getItemHandler().getItem(e.getCurrentItem());
                    if (optionalItem.isPresent()) {
                        if (e.getClick().isShiftClick()) {
                            optionalItem.get().onShiftClick((PetUser)user, menu, (IEntityPet)entityPet);
                            return;
                        }
                        optionalItem.get().onClick((PetUser)user, menu, (IEntityPet)entityPet);
                        return;
                    }
                    type.getPetData().forEach(petData -> petData.getItem(entityPet).ifPresent(o -> {
                        ItemBuilder builder = (ItemBuilder)o;
                        if (Utilities.isSimilar(builder.build(), e.getCurrentItem())) {
                            if (e.getClick().toString().toLowerCase().contains("right")) {
                                petData.onRightClick(entityPet);
                            } else {
                                petData.onLeftClick(entityPet);
                            }
                            petData.getItem(entityPet).ifPresent(o1 -> e.getInventory().setItem(e.getSlot(), ((ItemBuilder)o1).build()));
                        }
                    }));
                });
            });
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof PetDataHolder)) {
            return;
        }
        DataMenu menu = InventoryManager.PET_DATA;
        SimplePets.getUserManager().getPetUser((Player)e.getPlayer()).ifPresent(menu::reset);
    }
}

