/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.listeners;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.files.Config;

public class DamageListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPlayerFall(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle == null) {
            return;
        }
        if (!SimplePets.isPetEntity(vehicle)) {
            return;
        }
        SimplePets.getSpawnUtil().getHandle(vehicle).ifPresent(obj -> {
            IEntityPet pet = (IEntityPet)obj;
            SimplePets.getPetConfigManager().getPetConfig(pet.getPetType()).ifPresent(config -> {
                Config configuration = PetCore.getInstance().getConfiguration();
                if (config.canFly(player)) {
                    if (!ConfigOption.INSTANCE.PET_TOGGLES_FALL_DAMAGE_FLY.getValue().booleanValue()) {
                        return;
                    }
                    event.setCancelled(true);
                    return;
                }
                if (!ConfigOption.INSTANCE.PET_TOGGLES_FALL_DAMAGE_NON_FLY.getValue().booleanValue()) {
                    return;
                }
                event.setCancelled(true);
            });
        });
    }

    @EventHandler
    public void onCombust(EntityCombustEvent event) {
        if (!SimplePets.isPetEntity(event.getEntity())) {
            return;
        }
        event.setCancelled(true);
    }
}

