/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.web;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.libs.bslib.apache.ApacheUtils;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.json.JsonValue;
import simplepets.brainsynder.libs.bslib.utils.Callback;
import simplepets.brainsynder.libs.bslib.utils.ReturnValue;

public class WebConnector {
    public static void getOutputStream(String link, Plugin plugin, final ReturnValue<OutputStream> streamReturn) {
        CompletableFuture.runAsync(() -> {
            try {
                System.setProperty("http.agent", "Chrome");
                URL url = new URL(link);
                final URLConnection connection = url.openConnection();
                connection.addRequestProperty("User-Agent", "Mozilla/5.0");
                connection.addRequestProperty("Content-Encoding", "gzip");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                new BukkitRunnable(){

                    public void run() {
                        try {
                            streamReturn.run(connection.getOutputStream());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.runTask(plugin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void getInputStream(String link, Plugin plugin, final ReturnValue<InputStream> streamReturn) {
        CompletableFuture.runAsync(() -> {
            try {
                System.setProperty("http.agent", "Chrome");
                URL url = new URL(link);
                final URLConnection connection = url.openConnection();
                connection.addRequestProperty("User-Agent", "Mozilla/5.0");
                connection.addRequestProperty("Content-Encoding", "gzip");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                new BukkitRunnable(){

                    public void run() {
                        try {
                            streamReturn.run(connection.getInputStream());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.runTask(plugin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void getInputStreamString(String link, Plugin plugin, final ReturnValue<String> stringReturn) {
        CompletableFuture.runAsync(() -> {
            try {
                System.setProperty("http.agent", "Chrome");
                URL url = new URL(link);
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("User-Agent", "Mozilla/5.0");
                connection.addRequestProperty("Content-Encoding", "gzip");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                final InputStream stream = connection.getInputStream();
                new BukkitRunnable(){

                    public void run() {
                        try {
                            stringReturn.run(ApacheUtils.toString(stream));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.runTask(plugin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void uploadPaste(Plugin plugin, String text, final Callback<String, String> callback) {
        CompletableFuture.runAsync(() -> {
            try {
                final String urlBase = "https://pastelog.us";
                URL url = new URL(urlBase + "/api/paste/create");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setInstanceFollowRedirects(false);
                connection.setRequestMethod("POST");
                connection.setUseCaches(false);
                try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                    outputStream.write(("content=" + text).getBytes(StandardCharsets.UTF_8));
                }
                try (InputStream inputStream = connection.getInputStream();){
                    JsonValue value;
                    StringBuilder builder;
                    block19: {
                        JsonObject json;
                        String key;
                        String inputLine;
                        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
                        builder = new StringBuilder();
                        while ((inputLine = in.readLine()) != null) {
                            builder.append(inputLine);
                        }
                        value = Json.parse(builder.toString());
                        if (!value.isObject() || (key = (json = (JsonObject)value).getString("paste_key", "")) == null || key.isEmpty()) break block19;
                        new BukkitRunnable(){

                            public void run() {
                                callback.success(urlBase + "/paste/" + json.getString("paste_key", ""));
                            }
                        }.runTask(plugin);
                        return;
                    }
                    try {
                        new BukkitRunnable(){

                            public void run() {
                                callback.fail(value.toString());
                            }
                        }.runTask(plugin);
                    }
                    catch (Exception e) {
                        new BukkitRunnable(){

                            public void run() {
                                callback.fail(builder.toString());
                            }
                        }.runTask(plugin);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

