/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils.compnent;

import com.google.gson.stream.JsonWriter;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;

public final class Part {
    public ChatColor color = null;
    public Color customColor = null;
    public ChatColor[] styles = null;
    public String text = "";
    public String font = null;

    public Part() {
    }

    public Part(String text) {
        this.text = text;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("text", this.text);
        if (this.color != null) {
            json.add("color", this.color.name().toLowerCase());
        } else if (this.customColor != null && ServerVersion.isEqualNew(ServerVersion.v1_16_R1)) {
            json.add("color", Part.toHex(this.customColor.getRed(), this.customColor.getGreen(), this.customColor.getBlue()));
        }
        if (this.font != null) {
            json.add("font", this.font.toLowerCase());
        }
        if (this.styles != null) {
            for (ChatColor style : this.styles) {
                json.add(style.name().toLowerCase(), true);
            }
        }
        return json;
    }

    public JsonWriter writeJson(JsonWriter json) {
        try {
            json.beginObject().name("text").value(this.text);
            if (this.color != null) {
                json.name("color").value(this.color.name().toLowerCase());
            } else if (this.customColor != null && ServerVersion.isEqualNew(ServerVersion.v1_16_R1)) {
                json.name("color").value(Part.toHex(this.customColor.getRed(), this.customColor.getGreen(), this.customColor.getBlue()));
            }
            if (this.font != null) {
                json.name("font").value(this.font.toLowerCase());
            }
            if (this.styles != null) {
                for (ChatColor style : this.styles) {
                    json.name(style.name().toLowerCase()).value(true);
                }
            }
            return json.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return json;
        }
    }

    public static String toHex(int r, int g, int b) {
        return "#" + Part.toBrowserHexValue(r) + Part.toBrowserHexValue(g) + Part.toBrowserHexValue(b);
    }

    private static String toBrowserHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }
}

