/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.utils.Base64Wrapper;

public class SkullUtilities {
    public static PlayerProfile getProfile(Player player) {
        if (player == null) {
            throw new RuntimeException("Player is null");
        }
        return player.getPlayerProfile();
    }

    public static PlayerProfile getProfile(OfflinePlayer player) {
        if (player == null) {
            throw new RuntimeException("OfflinePlayer is null");
        }
        return player.getPlayerProfile();
    }

    public static PlayerProfile getProfile(ItemStack item) {
        return SkullUtilities.getProfile(item, UUID.randomUUID());
    }

    public static PlayerProfile getProfile(ItemStack item, UUID uuid) {
        if (!item.hasItemMeta()) {
            throw new RuntimeException("ItemStack is missing ItemMeta: " + String.valueOf(item));
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            throw new RuntimeException("ItemStack is not a player skull");
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        PlayerProfile profile = skullMeta.getOwnerProfile();
        if (profile == null) {
            profile = Bukkit.createPlayerProfile((UUID)uuid);
        }
        return profile;
    }

    public static PlayerProfile setProfileTexture(PlayerProfile profile, String url) {
        URL urlObject;
        if (Base64Wrapper.isEncoded(url)) {
            url = Base64Wrapper.decodeString(url);
            url = Json.parse(url).asObject().get("textures").asObject().get("SKIN").asObject().get("url").asString();
        }
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL: '" + url + "'", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }
}

