/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListPager<T>
extends ArrayList<T> {
    private final int contentLimit;

    public ListPager(int contentLimit) {
        this(contentLimit, new ArrayList());
    }

    public ListPager(int contentLimit, T ... objects) {
        this(contentLimit, Arrays.asList(objects));
    }

    public ListPager(int contentLimit, List<T> objects) {
        this.contentLimit = contentLimit;
        this.addAll(objects);
    }

    public int getContentLimit() {
        return this.contentLimit;
    }

    public int totalPages() {
        return (int)Math.ceil((double)this.size() / (double)this.contentLimit);
    }

    public boolean exists(int page) {
        return --page >= 0 && page < this.totalPages();
    }

    public List<T> getPage(int page) {
        if (--page < 0 || page >= this.totalPages()) {
            throw new IndexOutOfBoundsException("Index: " + page + ", Size: " + this.totalPages());
        }
        ArrayList objects = new ArrayList();
        int min = page * this.contentLimit;
        int max = page * this.contentLimit + this.contentLimit;
        if (max > this.size()) {
            max = this.size();
        }
        for (int i = min; max > i; ++i) {
            objects.add(this.get(i));
        }
        return objects;
    }
}

