/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.utils.BlockLocation;

public class Cuboid
implements Cloneable {
    protected final String worldName;
    protected final int x1;
    protected final int y1;
    protected final int z1;
    protected final int x2;
    protected final int y2;
    protected final int z2;
    private final List<Material> aboveMaterials = Arrays.asList(Material.AIR, Material.BARRIER);

    public Cuboid(BlockLocation l1, BlockLocation l2) {
        if (!l1.getWorld().getName().equals(l2.getWorld().getName())) {
            throw new IllegalArgumentException("Locations must be on the same world");
        }
        this.worldName = l1.getWorld().getName();
        this.x1 = Math.min(l1.getX(), l2.getX());
        this.y1 = Math.min(l1.getY(), l2.getY());
        this.z1 = Math.min(l1.getZ(), l2.getZ());
        this.x2 = Math.max(l1.getX(), l2.getX());
        this.y2 = Math.max(l1.getY(), l2.getY());
        this.z2 = Math.max(l1.getZ(), l2.getZ());
    }

    public Cuboid(Location l1, Location l2) {
        this(new BlockLocation(l1), new BlockLocation(l2));
    }

    public Cuboid(BlockLocation l1) {
        this(l1, l1);
    }

    public Cuboid(Cuboid other) {
        this(other.getWorld().getName(), other.x1, other.y1, other.z1, other.x2, other.y2, other.z2);
    }

    public Cuboid(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.worldName = world.getName();
        this.x1 = Math.min(x1, x2);
        this.x2 = Math.max(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.y2 = Math.max(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.z2 = Math.max(z1, z2);
    }

    private Cuboid(String worldName, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.worldName = worldName;
        this.x1 = Math.min(x1, x2);
        this.x2 = Math.max(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.y2 = Math.max(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid(StorageTagCompound compound) {
        this.worldName = compound.getString("worldName");
        this.x1 = compound.getInteger("x1");
        this.x2 = compound.getInteger("x2");
        this.y1 = compound.getInteger("y1");
        this.y2 = compound.getInteger("y2");
        this.z1 = compound.getInteger("z1");
        this.z2 = compound.getInteger("z2");
    }

    public StorageTagCompound serialize() {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setString("worldName", this.worldName);
        compound.setInteger("x1", this.x1);
        compound.setInteger("y1", this.y1);
        compound.setInteger("z1", this.z1);
        compound.setInteger("x2", this.x2);
        compound.setInteger("y2", this.y2);
        compound.setInteger("z2", this.z2);
        return compound;
    }

    public Location getLowerNE() {
        return new Location(this.getWorld(), (double)this.x1, (double)this.y1, (double)this.z1);
    }

    public Location getUpperSW() {
        return new Location(this.getWorld(), (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public List<Block> getBlocks() {
        CuboidIterator blockI = this.iterator();
        ArrayList<Block> copy = new ArrayList<Block>();
        while (blockI.hasNext()) {
            copy.add((Block)blockI.next());
        }
        return copy;
    }

    public Location getCenter() {
        int x1 = this.x2 + 1;
        int y1 = this.y2 + 1;
        int z1 = this.z2 + 1;
        return new Location(this.getWorld(), (double)this.x1 + (double)(x1 - this.x1) / 2.0, (double)this.y1 + (double)(y1 - this.y1) / 2.0, (double)this.z1 + (double)(z1 - this.z1) / 2.0);
    }

    public World getWorld() {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            throw new IllegalStateException("World '" + this.worldName + "' is not loaded");
        }
        return world;
    }

    public int getSizeX() {
        return this.x2 - this.x1 + 1;
    }

    public int getSizeY() {
        return this.y2 - this.y1 + 1;
    }

    public int getSizeZ() {
        return this.z2 - this.z1 + 1;
    }

    public int getLowerX() {
        return this.x1;
    }

    public int getLowerY() {
        return this.y1;
    }

    public int getLowerZ() {
        return this.z1;
    }

    public int getUpperX() {
        return this.x2;
    }

    public int getUpperY() {
        return this.y2;
    }

    public int getUpperZ() {
        return this.z2;
    }

    public Block[] corners() {
        Block[] res = new Block[8];
        World w = this.getWorld();
        res[0] = w.getBlockAt(this.x1, this.y1, this.z1);
        res[1] = w.getBlockAt(this.x1, this.y1, this.z2);
        res[2] = w.getBlockAt(this.x1, this.y2, this.z1);
        res[3] = w.getBlockAt(this.x1, this.y2, this.z2);
        res[4] = w.getBlockAt(this.x2, this.y1, this.z1);
        res[5] = w.getBlockAt(this.x2, this.y1, this.z2);
        res[6] = w.getBlockAt(this.x2, this.y2, this.z1);
        res[7] = w.getBlockAt(this.x2, this.y2, this.z2);
        return res;
    }

    public Cuboid expand(CuboidDirection dir, int amount) {
        switch (dir.ordinal()) {
            case 0: {
                return new Cuboid(this.worldName, this.x1 - amount, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case 2: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2 + amount, this.y2, this.z2);
            }
            case 1: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1 - amount, this.x2, this.y2, this.z2);
            }
            case 3: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2 + amount);
            }
            case 5: {
                return new Cuboid(this.worldName, this.x1, this.y1 - amount, this.z1, this.x2, this.y2, this.z2);
            }
            case 4: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2 + amount, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + String.valueOf((Object)dir));
    }

    public Cuboid shift(CuboidDirection dir, int amount) {
        return this.expand(dir, amount).expand(dir.opposite(), -amount);
    }

    public Cuboid outset(CuboidDirection dir, int amount) {
        return switch (dir.ordinal()) {
            case 6 -> this.expand(CuboidDirection.North, amount).expand(CuboidDirection.South, amount).expand(CuboidDirection.East, amount).expand(CuboidDirection.West, amount);
            case 7 -> this.expand(CuboidDirection.Down, amount).expand(CuboidDirection.Up, amount);
            case 8 -> this.outset(CuboidDirection.Horizontal, amount).outset(CuboidDirection.Vertical, amount);
            default -> throw new IllegalArgumentException("Invalid direction " + String.valueOf((Object)dir));
        };
    }

    public Cuboid inset(CuboidDirection dir, int amount) {
        return this.outset(dir, -amount);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2 && z >= this.z1 && z <= this.z2;
    }

    public boolean contains(Block b) {
        return this.contains(new BlockLocation(b.getLocation()));
    }

    public boolean contains(BlockLocation l) {
        if (!this.worldName.equals(l.getWorld().getName())) {
            return false;
        }
        return this.contains(l.getX(), l.getY(), l.getZ());
    }

    public int getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public byte getAverageLightLevel() {
        long total = 0L;
        int n = 0;
        for (Block b : this.getBlocks()) {
            if (!b.isEmpty()) continue;
            total += (long)b.getLightLevel();
            ++n;
        }
        return n > 0 ? (byte)(total / (long)n) : (byte)0;
    }

    public Cuboid getFace(CuboidDirection dir) {
        switch (dir.ordinal()) {
            case 5: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y1, this.z2);
            }
            case 4: {
                return new Cuboid(this.worldName, this.x1, this.y2, this.z1, this.x2, this.y2, this.z2);
            }
            case 0: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x1, this.y2, this.z2);
            }
            case 2: {
                return new Cuboid(this.worldName, this.x2, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case 1: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z1);
            }
            case 3: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z2, this.x2, this.y2, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + String.valueOf((Object)dir));
    }

    public Cuboid getBoundingCuboid(Cuboid other) {
        if (other == null) {
            return this;
        }
        int xMin = Math.min(this.x1, other.x1);
        int yMin = Math.min(this.y1, other.y1);
        int zMin = Math.min(this.z1, other.z1);
        int xMax = Math.max(this.x2, other.x2);
        int yMax = Math.max(this.y2, other.y2);
        int zMax = Math.max(this.z2, other.z2);
        return new Cuboid(this.worldName, xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public BlockLocation getRandomLocation(boolean valid, boolean checkInside) {
        return this.getRandomLocation(valid, checkInside, false);
    }

    public BlockLocation getRandomLocation(boolean valid, boolean checkInside, boolean allowedInBlocks) {
        int x = MathUtils.random(this.x1, this.x2);
        int y = MathUtils.random(this.y1, this.y2);
        int z = MathUtils.random(this.z1, this.z2);
        if (this.contains(x, y += MathUtils.random(0, 1), z)) {
            Block block;
            Material type;
            BlockLocation blockLocation = new BlockLocation(this.getWorld(), x, y, z);
            if (valid) {
                while (blockLocation.toLocation().getBlock().getType() != Material.AIR) {
                    blockLocation.setY(blockLocation.getY() + 1);
                }
                while (!this.isOnGround(blockLocation)) {
                    blockLocation.setY(blockLocation.getY() - 1);
                }
                Block feet = this.getRelativeBlock(blockLocation.getX(), blockLocation.getY(), blockLocation.getZ());
                Block head = this.getRelativeBlock(blockLocation.getX(), blockLocation.getY() + 1, blockLocation.getZ());
                if (!this.contains(blockLocation) || feet.getType() != Material.AIR && head.getType() != Material.AIR || feet.getType().isSolid() && head.getType().isSolid()) {
                    return this.getRandomLocation(valid, checkInside, allowedInBlocks);
                }
            }
            if (checkInside && this.isInside(blockLocation)) {
                return this.getRandomLocation(valid, checkInside, allowedInBlocks);
            }
            if (!(allowedInBlocks || (type = (block = blockLocation.toLocation().getBlock()).getType()) == Material.AIR && type.name().contains("LEAVES") && type.isTransparent() && block.isLiquid())) {
                return this.getRandomLocation(valid, checkInside, allowedInBlocks);
            }
            return blockLocation;
        }
        return null;
    }

    public boolean isInside(BlockLocation loc) {
        Material type;
        Block block;
        int height;
        int x = loc.getX();
        int y = loc.getY();
        int z = loc.getZ();
        boolean underBlocks = false;
        boolean overBlocks = false;
        if (!this.contains(x, y, z)) {
            return false;
        }
        for (height = y; height < loc.getY() + 15 && this.contains(block = loc.getWorld().getBlockAt(x, height, z)); ++height) {
            type = block.getType();
            if (type == Material.AIR && type.name().contains("LEAVES") && type.isTransparent() && block.isLiquid()) continue;
            underBlocks = true;
            break;
        }
        for (height = y; height > loc.getY() - 15 && this.contains(block = loc.getWorld().getBlockAt(x, height, z)); --height) {
            type = block.getType();
            if (type == Material.AIR && type.name().contains("LEAVES") && type.isTransparent() && block.isLiquid()) continue;
            overBlocks = true;
            break;
        }
        return underBlocks && overBlocks;
    }

    public Collection<Entity> getEntities() {
        HashMap entities = new HashMap();
        this.getChunks().forEach(chunk -> {
            for (Entity entity : chunk.getEntities()) {
                if (!this.contains(new BlockLocation(entity.getLocation())) || entities.containsKey(entity.getUniqueId().toString())) continue;
                entities.put(entity.getUniqueId().toString(), entity);
            }
        });
        return entities.values();
    }

    private boolean isOnGround(BlockLocation blockLocation) {
        Block block = blockLocation.toLocation().getBlock().getRelative(BlockFace.DOWN);
        return block.getType().isSolid() || block.isLiquid();
    }

    public Block getRelativeBlock(int x, int y, int z) {
        return this.getWorld().getBlockAt(this.x1 + x, this.y1 + y, this.z1 + z);
    }

    public Block getRelativeBlock(World w, int x, int y, int z) {
        return w.getBlockAt(this.x1 + x, this.y1 + y, this.z1 + z);
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> res = new ArrayList<Chunk>();
        World w = this.getWorld();
        int x1 = this.x1 & 0xFFFFFFF0;
        int x2 = this.x2 & 0xFFFFFFF0;
        int z1 = this.z1 & 0xFFFFFFF0;
        int z2 = this.z2 & 0xFFFFFFF0;
        for (int x = x1; x <= x2; x += 16) {
            for (int z = z1; z <= z2; z += 16) {
                res.add(w.getChunkAt(x >> 4, z >> 4));
            }
        }
        return res;
    }

    public CuboidIterator iterator() {
        return new CuboidIterator(this.getWorld(), this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public Cuboid clone() {
        return new Cuboid(this);
    }

    public String toString() {
        return "Cuboid: " + this.worldName + "," + this.x1 + "," + this.y1 + "," + this.z1 + "=>" + this.x2 + "," + this.y2 + "," + this.z2;
    }

    public boolean isEmpty() {
        for (Block b : this.getBlocks()) {
            if (b.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public BlockLocation getCorner1() {
        return new BlockLocation(Bukkit.getWorld((String)this.worldName), this.x1, this.y1, this.z1);
    }

    public BlockLocation getCorner2() {
        return new BlockLocation(Bukkit.getWorld((String)this.worldName), this.x2, this.y2, this.z2);
    }

    public static class CuboidIterator
    implements Iterator<Block> {
        private World w;
        private int baseX;
        private int baseY;
        private int baseZ;
        private int x;
        private int y;
        private int z;
        private int sizeX;
        private int sizeY;
        private int sizeZ;

        public CuboidIterator(World w, int x1, int y1, int z1, int x2, int y2, int z2) {
            this.w = w;
            this.baseX = x1;
            this.baseY = y1;
            this.baseZ = z1;
            this.sizeX = Math.abs(x2 - x1) + 1;
            this.sizeY = Math.abs(y2 - y1) + 1;
            this.sizeZ = Math.abs(z2 - z1) + 1;
            this.z = 0;
            this.y = 0;
            this.x = 0;
        }

        @Override
        public boolean hasNext() {
            return this.x < this.sizeX && this.y < this.sizeY && this.z < this.sizeZ;
        }

        @Override
        public Block next() {
            Block b = this.w.getBlockAt(this.baseX + this.x, this.baseY + this.y, this.baseZ + this.z);
            if (++this.x >= this.sizeX) {
                this.x = 0;
                if (++this.y >= this.sizeY) {
                    this.y = 0;
                    ++this.z;
                }
            }
            return b;
        }

        @Override
        public void remove() {
        }
    }

    public static enum CuboidDirection {
        North,
        East,
        South,
        West,
        Up,
        Down,
        Horizontal,
        Vertical,
        Both,
        Unknown;


        public CuboidDirection opposite() {
            switch (this.ordinal()) {
                case 0: {
                    return South;
                }
                case 1: {
                    return West;
                }
                case 2: {
                    return North;
                }
                case 3: {
                    return East;
                }
                case 6: {
                    return Vertical;
                }
                case 7: {
                    return Horizontal;
                }
                case 4: {
                    return Down;
                }
                case 5: {
                    return Up;
                }
                case 8: {
                    return Both;
                }
            }
            return Unknown;
        }
    }
}

