/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.libs.bslib.utils.compnent.Part;

public class Colorize {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#(\\w{5}[0-9a-fA-F])");
    private static Method of;

    public static net.md_5.bungee.api.ChatColor fetchColor(String hex) {
        return Colorize.fetchColor(hex, net.md_5.bungee.api.ChatColor.WHITE);
    }

    public static net.md_5.bungee.api.ChatColor fetchColor(String hex, net.md_5.bungee.api.ChatColor fallback) {
        if (of == null) {
            return fallback;
        }
        if (hex == null || ((String)hex).isEmpty()) {
            return fallback;
        }
        if (((String)hex).startsWith("&#")) {
            hex = ((String)hex).replace("&", "");
        }
        if (!((String)hex).startsWith("#")) {
            hex = "#" + (String)hex;
        }
        return (net.md_5.bungee.api.ChatColor)Reflection.invoke(of, null, hex);
    }

    public static net.md_5.bungee.api.ChatColor fetchColor(Color color) {
        if (color == null) {
            return net.md_5.bungee.api.ChatColor.WHITE;
        }
        return Colorize.fetchColor(Colorize.toHex(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public static String translateBungee(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String translateBukkit(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static boolean containsHexColors(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        text = text.replace('\u00a7', '&');
        Matcher matcher = HEX_PATTERN.matcher(text);
        return matcher.find();
    }

    public static String translateBungeeHex(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('\u00a7', '&');
        Matcher matcher = HEX_PATTERN.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = "";
            if (of != null) {
                try {
                    replacement = String.valueOf(Reflection.invoke(of, null, "#" + matcher.group(1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            matcher.appendReplacement(buffer, replacement).toString();
        }
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    public static String removeHexColor(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('\u00a7', '&');
        Pattern word = Pattern.compile("&x");
        Matcher matcher = word.matcher(text);
        char[] chars = text.toCharArray();
        while (matcher.find()) {
            StringBuilder builder = new StringBuilder();
            int start = matcher.start();
            int end = start + 13;
            if (end > text.length()) continue;
            for (int i = start; i < end; ++i) {
                builder.append(chars[i]);
            }
            String hex = builder.toString();
            hex = hex.replace("&x", "").replace("&", "");
            text = text.replace(builder.toString(), "&#" + hex);
        }
        return text;
    }

    public static JsonObject convertParts2Json(List<Part> parts) {
        JsonObject json = new JsonObject();
        json.add("text", "");
        JsonArray extra = new JsonArray();
        for (Part part : parts) {
            extra.add(part.toJson());
        }
        json.add("extra", extra);
        return json;
    }

    public static List<Part> splitMessageToParts(String value) {
        ArrayList<Part> parts = new ArrayList<Part>();
        if (value == null || value.isEmpty()) {
            return parts;
        }
        if ((value = value.replace('\u00a7', '&')).contains("&")) {
            String[] args;
            for (String string : args = value.split("&")) {
                if (string == null || string.isEmpty()) continue;
                Part part = new Part();
                if (string.startsWith("#")) {
                    StringBuilder HEX = new StringBuilder();
                    int end = 6;
                    for (int i = -1; i < end; ++i) {
                        HEX.append(string.charAt(i + 1));
                    }
                    part.text = string.replace(HEX.toString(), "");
                    part.customColor = Colorize.hex2Color(HEX.toString());
                } else {
                    ChatColor color = ChatColor.getByChar((char)string.charAt(0));
                    if (color == null) {
                        part.text = "&" + string;
                    } else {
                        part.text = string.replaceFirst(String.valueOf(string.charAt(0)), "");
                        part.color = color;
                    }
                }
                parts.add(part);
            }
        } else {
            parts.add(new Part(value));
        }
        return parts;
    }

    public static Color hex2Color(String hex) {
        return Color.fromRGB((int)Integer.valueOf(hex.substring(1, 3), 16), (int)Integer.valueOf(hex.substring(3, 5), 16), (int)Integer.valueOf(hex.substring(5, 7), 16));
    }

    public static String toHex(int r, int g, int b) {
        return "#" + Colorize.toBrowserHexValue(r) + Colorize.toBrowserHexValue(g) + Colorize.toBrowserHexValue(b);
    }

    private static String toBrowserHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    static {
        try {
            of = Reflection.getMethod(net.md_5.bungee.api.ChatColor.class, "of", String.class);
        }
        catch (Exception e) {
            of = null;
        }
    }
}

