/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;

public class AdvString {
    public static String getPaddedString(String text, char paddingChar, int maxPadding, AlignText alignText) {
        if (text == null) {
            throw new NullPointerException("Can not add padding in null String!");
        }
        int length = text.length();
        int padding = (maxPadding - length) / 2;
        if (padding <= 0) {
            return text;
        }
        String empty = "";
        String hash = "#";
        int extra = length % 2 == 0 ? 1 : 0;
        Object leftPadding = "%" + padding + "s";
        Object rightPadding = "%" + (padding - extra) + "s";
        switch (alignText.ordinal()) {
            case 0: {
                leftPadding = "%s";
                rightPadding = "%" + (padding + (padding - extra)) + "s";
                break;
            }
            case 1: {
                rightPadding = "%s";
                leftPadding = "%" + (padding + (padding - extra)) + "s";
            }
        }
        String strFormat = (String)leftPadding + "%s" + (String)rightPadding;
        String formattedString = String.format(strFormat, empty, hash, empty);
        String paddedString = formattedString.replace(' ', paddingChar).replace(hash, text);
        return paddedString;
    }

    public static String replaceLast(String target, String replacement, String haystack) {
        int pos = haystack.lastIndexOf(target);
        if (pos > -1) {
            return haystack.substring(0, pos) + replacement + haystack.substring(pos + target.length());
        }
        return haystack;
    }

    public static boolean contains(String string, char character, int count) {
        if (count == -1) {
            return string.contains(String.valueOf(character));
        }
        int i = 0;
        for (char c : string.toCharArray()) {
            if (c != character) continue;
            ++i;
        }
        return i == count;
    }

    public static String after(String needle, String haystack) {
        return haystack.substring(haystack.indexOf(needle) + needle.length());
    }

    public static String afterLast(String needle, String haystack) {
        return haystack.substring(AdvString.reversePos(needle, haystack) + needle.length());
    }

    public static String before(String needle, String haystack) {
        return haystack.substring(0, haystack.indexOf(needle));
    }

    public static String beforeLast(String needle, String haystack) {
        return haystack.substring(0, AdvString.reversePos(needle, haystack));
    }

    public static String between(String first, String last, String haystack) {
        return AdvString.before(last, AdvString.after(first, haystack));
    }

    public static String betweenLast(String first, String last, String haystack) {
        return AdvString.afterLast(first, AdvString.beforeLast(last, haystack));
    }

    public static int reversePos(String needle, String haystack) {
        int pos = AdvString.reverse(haystack).indexOf(AdvString.reverse(needle));
        return haystack.length() - pos - needle.length();
    }

    public static String reverse(String input) {
        char[] chars = input.toCharArray();
        ArrayList<Character> characters = new ArrayList<Character>();
        for (char c : chars) {
            characters.add(Character.valueOf(c));
        }
        Collections.reverse(characters);
        ListIterator iterator = characters.listIterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
        }
        return builder.toString();
    }

    public static String scramble(String input) {
        StringBuilder out = new StringBuilder();
        for (String part : input.split(" ")) {
            ArrayList<Character> characters = new ArrayList<Character>();
            for (char c : part.toCharArray()) {
                characters.add(Character.valueOf(c));
            }
            StringBuilder output = new StringBuilder(part.length());
            while (characters.size() != 0) {
                int rndm = (int)(Math.random() * (double)characters.size());
                output.append(characters.remove(rndm));
            }
            out.append((CharSequence)output).append(' ');
        }
        return out.toString().trim();
    }

    public static enum AlignText {
        LEFT,
        RIGHT,
        CENTER;

    }
}

