/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import simplepets.brainsynder.libs.paperlib.PaperLib;

public class Reflection {
    private static final HashMap<Class<? extends Entity>, Method> handles = new HashMap();

    public static void sendPacket(Player player, Object packet) throws IllegalArgumentException {
        if (packet == null) {
            return;
        }
        Object handle = Reflection.getHandle((Entity)player);
        if (handle == null) {
            return;
        }
        Object connection = Reflection.getNMSFields(handle, "server.level", "playerConnection", "b");
        Method sendPacket = Reflection.getMethod(Reflection.getNmsClass("PlayerConnection", "server.network"), new String[]{"sendPacket", "a"}, Reflection.getNmsClass("Packet", "network.protocol"));
        if (connection == null) {
            return;
        }
        if (sendPacket == null) {
            return;
        }
        try {
            sendPacket.invoke(connection, packet);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public static <T> T invokeNMSStaticMethod(String className, String method, Class<?>[] parameterClasses, Object ... params) {
        return Reflection.invokeNMSMethod(className, method, null, parameterClasses, params);
    }

    public static <T> T initiateClass(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T initiateClass(Constructor<?> constructor, Object ... args) {
        try {
            return (T)constructor.newInstance(args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor<?> fillConstructor(Class<?> clazz, Class<?> ... values) {
        try {
            return clazz.getDeclaredConstructor(values);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static <T> T invokeNMSMethod(String className, String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        return Reflection.invokeNMSMethod(className, "", method, invoker, parameterClasses, new Object[0]);
    }

    public static <T> T invokeNMSMethod(String className, String subLoc, String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        try {
            Class<?> e = Reflection.getNmsClass(className, subLoc);
            Method m = e.getDeclaredMethod(method, parameterClasses);
            m.setAccessible(true);
            return (T)m.invoke(invoker, params);
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeNMSMethod(String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        Objects.requireNonNull(invoker, "Invoker cannot be null");
        return Reflection.invokeNMSMethod(invoker.getClass().getSimpleName(), method, invoker, parameterClasses, params);
    }

    public static <T> T invokeNMSMethod(String method, Object invoker) {
        Objects.requireNonNull(invoker, "Invoker cannot be null");
        return Reflection.invokeNMSMethod(method, invoker, new Class[0], new Object[0]);
    }

    public static Object newNMS(String className) {
        return Reflection.newNMS(className, "", new Class[0], new Object[0]);
    }

    @Deprecated
    public static Object newNMS(String className, Class<?>[] parameterClasses, Object ... params) {
        return Reflection.newNMS(className, "", parameterClasses, params);
    }

    public static Object newNMS(String className, String subLoc, Class<?>[] parameterClasses, Object ... params) {
        try {
            Class<?> ex = Reflection.getNmsClass(className, subLoc);
            Constructor<?> constructor = ex.getDeclaredConstructor(parameterClasses);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    public static <T> T getNMSFields(Object owner, String subLoc, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                return Reflection.getNMSField(owner.getClass().getSimpleName(), subLoc, owner, fieldName);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        return null;
    }

    public static <T> T getNMSField(Object owner, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return Reflection.getNMSField(owner.getClass().getSimpleName(), owner, fieldName);
    }

    @Deprecated
    public static <T> T getNMSField(String className, Object owner, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return Reflection.getNMSField(className, "", owner, fieldName);
    }

    public static <T> T getNMSField(String className, String subLoc, Object owner, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> ex = Reflection.getNmsClass(className, subLoc);
        Field field = ex.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(owner);
    }

    public static <T> T getNMSStaticField(String className, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return Reflection.getNMSField(className, null, fieldName);
    }

    public static <T> T invokeBukkitStaticMethod(String className, String method, Class<?>[] parameterClasses, Object ... params) {
        return Reflection.invokeBukkitMethod(className, method, null, parameterClasses, params);
    }

    public static <T> T invokeBukkitMethod(String className, String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        try {
            Class e = Reflection.getCBCClass(className);
            Method m = e.getDeclaredMethod(method, parameterClasses);
            m.setAccessible(true);
            return (T)m.invoke(invoker, params);
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeBukkitMethod(String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        Object version = Reflection.getBukkitPackageVersion() + ".";
        if (PaperLib.isPaper() && ((String)version).equals(".")) {
            version = "";
        }
        return Reflection.invokeBukkitMethod(invoker.getClass().getName().replace("org.bukkit.craftbukkit." + (String)version, ""), method, invoker, parameterClasses, params);
    }

    public static <T> T invokeBukkitMethod(String method, Object invoker) {
        return Reflection.invokeBukkitMethod(method, invoker, new Class[0], new Object[0]);
    }

    public static Object newBukkit(String className) {
        return Reflection.newBukkit(className, new Class[0], new Object[0]);
    }

    public static Object newBukkit(String className, Class<?>[] parameterClasses, Object ... params) {
        try {
            Class ex = Reflection.getCBCClass(className);
            Constructor constructor = ex.getConstructor(parameterClasses);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    public static <T> T getBukkitField(Object owner, String fieldName) {
        Object version = Reflection.getBukkitPackageVersion() + ".";
        if (PaperLib.isPaper() && ((String)version).equals(".")) {
            version = "";
        }
        return Reflection.getBukkitField(owner.getClass().getName().replace("org.bukkit.craftbukkit." + (String)version, ""), owner, fieldName);
    }

    public static <T> T getBukkitField(String className, Object owner, String fieldName) {
        try {
            Class ex = Reflection.getCBCClass(className);
            Field field = ex.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    public static <T> T getBukkitStaticField(String className, String fieldName) {
        return Reflection.getBukkitField(className, null, fieldName);
    }

    public static Object getEntityHandle(Entity entity) {
        return Reflection.invokeMethod(Reflection.getMethod(Reflection.getCBCClass("entity.CraftEntity"), "getHandle", new Class[0]), entity, new Object[0]);
    }

    public static Object getHandle(Entity entity) {
        try {
            if (handles.get(entity.getClass()) != null) {
                return handles.get(entity.getClass()).invoke((Object)entity, new Object[0]);
            }
            Method entity_getHandle = entity.getClass().getMethod("getHandle", new Class[0]);
            handles.put(entity.getClass(), entity_getHandle);
            return entity_getHandle.invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T getPrivateField(String fieldName, Class clazz, Object object) {
        Object o = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            o = field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return (T)o;
    }

    public Object getPrivateStatic(Class<?> clazz, String f) throws Exception {
        Field field = clazz.getDeclaredField(f);
        field.setAccessible(true);
        return field.get(null);
    }

    public static Class<?> getNmsClass(String name) {
        Object version = Reflection.getBukkitPackageVersion() + ".";
        if (PaperLib.isPaper() && ((String)version).equals(".")) {
            version = "";
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("net.minecraft.server." + (String)version + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return clazz;
    }

    public static Class<?> getNmsClass(String name, String subLoc) {
        Class<?> clazz;
        try {
            clazz = subLoc == null || subLoc.length() == 0 ? Class.forName("net.minecraft." + name) : Class.forName("net.minecraft." + subLoc + "." + name);
        }
        catch (ClassNotFoundException ex) {
            clazz = Reflection.getNmsClass(name);
        }
        return clazz;
    }

    public static String getBukkitPackageVersion() {
        try {
            return Bukkit.getServer().getClass().getPackage().getName().substring(23);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static Object invoke(Method method, Object instance, Object ... parameters) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public static <T> T getWorldHandle(World world) {
        return Reflection.invokeMethod(Reflection.getMethod(Reflection.getCBCClass("CraftWorld"), "getHandle", new Class[0]), world, new Object[0]);
    }

    public static Field getField(Class clazz, String name) {
        try {
            return Reflection.setFieldAccessible(clazz.getDeclaredField(name));
        }
        catch (Throwable var3) {
            return null;
        }
    }

    public static Constructor getConstructor(Class cl, Class ... classes) {
        try {
            Constructor var8 = cl.getDeclaredConstructor(classes);
            var8.setAccessible(true);
            return var8;
        }
        catch (Throwable var7) {
            StringBuilder sb = new StringBuilder();
            Class[] var3 = classes;
            int var4 = classes.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                Class c = var3[var5];
                sb.append(", ").append(c.getName());
            }
            return null;
        }
    }

    public static Field getFirstFieldOfType(Class cl, Class returnType, String ... matches) {
        for (Field f : cl.getDeclaredFields()) {
            Type[] types;
            if (f.getType() != returnType || !(f.getGenericType() instanceof ParameterizedType) || matches.length != (types = ((ParameterizedType)f.getGenericType()).getActualTypeArguments()).length) continue;
            boolean match = true;
            for (int i = 0; i < matches.length; ++i) {
                if (((Class)types[i]).getName().matches(matches[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return Reflection.setFieldAccessible(f);
        }
        return null;
    }

    public static Field setFieldAccessible(Field f) {
        try {
            f.setAccessible(true);
            return f;
        }
        catch (Throwable var3) {
            return null;
        }
    }

    public static Class getCBCClass(String className) {
        Object version = Reflection.getBukkitPackageVersion() + ".";
        if (PaperLib.isPaper() && ((String)version).equals(".")) {
            version = "";
        }
        try {
            return Class.forName("org.bukkit.craftbukkit." + (String)version + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getBukkitClass(String className) {
        try {
            return Class.forName("org.bukkit." + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            return clazz.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String[] methodName, Class<?> ... params) {
        for (String method : methodName) {
            try {
                return clazz.getDeclaredMethod(method, params);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            throw new NoSuchMethodException("Methods " + Arrays.toString(methodName) + " were not found to exist in class " + clazz.getSimpleName());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... args) {
        try {
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException var4) {
            return null;
        }
        catch (InvocationTargetException var5) {
            var5.printStackTrace();
            return null;
        }
    }
}

