/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.optional;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import simplepets.brainsynder.libs.bslib.optional.BiOptional;

public class BiOptionalMapper<T, U, R> {
    private final BiOptional<T, U> biOptional;
    private R result = null;

    BiOptionalMapper(BiOptional<T, U> biOptional) {
        this.biOptional = biOptional;
    }

    public BiOptionalMapper<T, U, R> onFirstOnlyPresent(Function<? super T, ? extends R> firstMapper) {
        if (this.biOptional.isFirstOnlyPresent()) {
            this.setResult(firstMapper.apply(this.biOptional.first().get()));
        }
        return this;
    }

    public BiOptionalMapper<T, U, R> onSecondOnlyPresent(Function<? super U, ? extends R> secondMapper) {
        if (this.biOptional.isSecondOnlyPresent()) {
            this.setResult(secondMapper.apply(this.biOptional.second().get()));
        }
        return this;
    }

    public BiOptionalMapper<T, U, R> onBothPresent(BiFunction<? super T, ? super U, ? extends R> bothMapper) {
        if (this.biOptional.areBothPresent()) {
            this.setResult(bothMapper.apply(this.biOptional.first().get(), this.biOptional.second().get()));
        }
        return this;
    }

    public BiOptionalMapper<T, U, R> onNonePresent(Supplier<? extends R> supplier) {
        if (this.biOptional.areNonePresent()) {
            this.setResult(supplier.get());
        }
        return this;
    }

    public BiOptionalMapper<T, U, R> onNonePresent(R other) {
        if (this.biOptional.areNonePresent()) {
            this.setResult(other);
        }
        return this;
    }

    public <X extends Throwable> BiOptionalMapper<T, U, R> onNonePresentThrow(Supplier<? extends X> throwableProvider) throws X {
        this.biOptional.ifNonePresentThrow(throwableProvider);
        return this;
    }

    public R result() {
        if (this.result == null) {
            throw new IllegalStateException("Result absent");
        }
        return this.result;
    }

    public Optional<R> optionalResult() {
        return Optional.ofNullable(this.result);
    }

    private void setResult(R result) {
        if (result == null) {
            throw new IllegalArgumentException("Null obtained from a mapper");
        }
        if (this.result != null) {
            throw new IllegalStateException("Result already present: " + String.valueOf(this.result));
        }
        this.result = result;
    }
}

