/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nms;

import java.lang.reflect.Method;
import java.util.Collection;
import org.bukkit.entity.Player;
import simplepets.brainsynder.libs.bslib.reflection.FieldAccessor;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class TabMessage {
    private String header = "";
    private String footer = "";
    private static TabMessage tabMessage = null;
    private final FieldAccessor headerField;
    private final FieldAccessor footerField;
    private final Method serializerMethod;

    private TabMessage() {
        Class<?> chatSerializer = Reflection.getNmsClass("IChatBaseComponent$ChatSerializer", "network.chat");
        this.serializerMethod = Reflection.getMethod(chatSerializer, "a", String.class);
        Class<?> packet = Reflection.getNmsClass("PacketPlayOutPlayerListHeaderFooter", "network.protocol.game");
        this.headerField = FieldAccessor.getField(packet, "a", Reflection.getNmsClass("IChatBaseComponent", "network.chat"));
        this.footerField = FieldAccessor.getField(packet, "b", Reflection.getNmsClass("IChatBaseComponent", "network.chat"));
    }

    public String getHeader() {
        return this.header;
    }

    public String getFooter() {
        return this.footer;
    }

    public TabMessage setHeader(String header) {
        this.header = header;
        return this;
    }

    public TabMessage setFooter(String footer) {
        this.footer = footer;
        return this;
    }

    public TabMessage setHeaderFooter(String header, String footer) {
        this.header = header;
        this.footer = footer;
        return this;
    }

    public void send(Player player) {
        try {
            Object packet = Reflection.getNmsClass("PacketPlayOutPlayerListHeaderFooter", "network.protocol.game").newInstance();
            if (this.header != null && !this.header.isEmpty()) {
                this.headerField.set(packet, this.buildMessage(this.header));
            }
            if (this.footer != null && !this.footer.isEmpty()) {
                this.footerField.set(packet, this.buildMessage(this.footer));
            }
            Reflection.sendPacket(player, packet);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void send(Iterable<Player> players) {
        for (Player player : players) {
            this.send(player);
        }
    }

    public void send(Collection<? extends Player> players) {
        for (Player player : players) {
            this.send(player);
        }
    }

    public static TabMessage getInstance() {
        if (tabMessage != null) {
            return tabMessage;
        }
        tabMessage = new TabMessage();
        return tabMessage;
    }

    private Object buildMessage(String text) {
        return Reflection.invoke(this.serializerMethod, null, "{\"text\": \"" + Colorize.translateBungeeHex(text) + "\"}");
    }
}

