/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nms;

import org.bukkit.Material;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.apache.EnumUtils;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.utils.DyeColorWrapper;

public class DataConverter {
    public static ItemBuilder getColoredMaterial(MaterialType type, DyeColorWrapper dye) {
        if (ServerVersion.isOlder(ServerVersion.v1_13_R1)) {
            return DataConverter.toBuilder(DataConverter.getMaterial(type.name()), dye.getWoolData());
        }
        String name = dye.name();
        if (name.equalsIgnoreCase("SILVER")) {
            name = "LIGHT_GRAY";
        }
        Material material = null;
        if (ServerVersion.isEqualNew(ServerVersion.v1_14_R1)) {
            if (type == MaterialType.DYE) {
                return DataConverter.toBuilder(DataConverter.getMaterial(name + "_DYE"), -1);
            }
        } else if (type == MaterialType.INK_SACK || type == MaterialType.DYE) {
            material = dye == DyeColorWrapper.WHITE ? DataConverter.getMaterial("BONE_MEAL") : (dye == DyeColorWrapper.YELLOW ? DataConverter.getMaterial("DANDELION_YELLOW") : (dye == DyeColorWrapper.BLUE ? DataConverter.getMaterial("LAPIS_LAZULI") : (dye == DyeColorWrapper.BROWN ? DataConverter.getMaterial("COCOA_BEANS") : (dye == DyeColorWrapper.GREEN ? DataConverter.getMaterial("CACTUS_GREEN") : (dye == DyeColorWrapper.RED ? DataConverter.getMaterial("ROSE_RED") : (dye == DyeColorWrapper.BLACK ? DataConverter.getMaterial("INK_SAC", "INK_SACK") : DataConverter.getMaterial(name + "_DYE")))))));
        }
        if (material == null) {
            material = DataConverter.getMaterial(name + "_" + type.getName());
        }
        return DataConverter.toBuilder(material, -1);
    }

    private static ItemBuilder toBuilder(Material material, int data) {
        ItemBuilder builder = new ItemBuilder(material);
        if (data != -1) {
            builder.withDurability(data);
        }
        return builder;
    }

    public static Material getMaterial(String name) {
        return DataConverter.getMaterial(name, null);
    }

    public static Material getMaterial(String name, String fallback) {
        if (EnumUtils.isValidEnum(Material.class, name = name.toUpperCase())) {
            return Material.valueOf((String)name);
        }
        if (fallback != null && !fallback.isEmpty()) {
            return DataConverter.getMaterial(fallback);
        }
        return Material.STONE;
    }

    public static enum MaterialType {
        STAINED_GLASS_PANE,
        WOOL,
        STAINED_CLAY("TERRACOTTA"),
        INK_SACK,
        DYE,
        CONCRETE,
        CONCRETE_POWDER;

        private final String name;

        private MaterialType() {
            this.name = this.name();
        }

        private MaterialType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

