/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.bukkit.Color;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagString
extends StorageBase {
    private String data;

    public StorageTagString() {
        this("");
    }

    public StorageTagString(String data) {
        Objects.requireNonNull(data, "Null string not allowed");
        this.data = data;
    }

    public StorageTagString(Color color) {
        Objects.requireNonNull(color, "Null color not allowed");
        this.data = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    static String configure(String data) {
        StringBuilder stringbuilder = new StringBuilder("\"");
        for (int i = 0; i < data.length(); ++i) {
            char c0 = data.charAt(i);
            if (c0 == '\\' || c0 == '\"') {
                stringbuilder.append('\\');
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.append('\"').toString();
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeUTF(this.data);
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(288L);
        this.data = input.readUTF();
        sizeTracker.read(16 * this.data.length());
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public String toString() {
        return StorageTagString.configure(this.data);
    }

    @Override
    public StorageTagString copy() {
        return new StorageTagString(this.data);
    }

    @Override
    public boolean hasNoTags() {
        return this.data.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        StorageTagString nbttagstring = (StorageTagString)o;
        return this.data == null && nbttagstring.data == null || Objects.equals(this.data, nbttagstring.data);
    }

    public Color getAsColor() {
        int b;
        int g;
        if (!this.data.contains(",")) {
            return null;
        }
        String[] args = this.data.replace(" ", "").split(",");
        if (args.length != 3) {
            return null;
        }
        int r = Integer.parseInt(args[0]);
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if ((g = Integer.parseInt(args[1])) > 255) {
            r = 255;
        }
        if (g < 0) {
            r = 0;
        }
        if ((b = Integer.parseInt(args[2])) > 255) {
            r = 255;
        }
        if (b < 0) {
            r = 0;
        }
        return Color.fromRGB((int)r, (int)g, (int)b);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.data.hashCode();
    }

    @Override
    public String getString() {
        return this.data;
    }

    public long getLong() {
        try {
            return Long.parseLong(this.data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public short getShort() {
        try {
            return Short.parseShort(this.data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public byte getByte() {
        try {
            return Byte.parseByte(this.data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public float getFloat() {
        try {
            return Float.parseFloat(this.data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }
}

