/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.other.IStorageList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagLongArray
extends StorageBase
implements IStorageList<long[]> {
    private long[] longArray;

    StorageTagLongArray() {
    }

    public StorageTagLongArray(long[] longs) {
        this.longArray = longs;
    }

    public StorageTagLongArray(List<Long> longList) {
        this(StorageTagLongArray.toArray(longList));
    }

    @Override
    public long[] getList() {
        return this.longArray;
    }

    private static long[] toArray(List<Long> longList) {
        long[] along = new long[longList.size()];
        for (int i = 0; i < longList.size(); ++i) {
            Long olong = longList.get(i);
            along[i] = olong == null ? 0L : olong;
        }
        return along;
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeInt(this.longArray.length);
        for (long i : this.longArray) {
            output.writeLong(i);
        }
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(192L);
        int i = input.readInt();
        sizeTracker.read(64 * i);
        this.longArray = new long[i];
        for (int j = 0; j < i; ++j) {
            this.longArray[j] = input.readLong();
        }
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[L;");
        for (int i = 0; i < this.longArray.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.longArray[i]).append('L');
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public StorageTagLongArray copy() {
        long[] along = new long[this.longArray.length];
        System.arraycopy(this.longArray, 0, along, 0, this.longArray.length);
        return new StorageTagLongArray(along);
    }

    @Override
    public boolean equals(Object instance) {
        return super.equals(instance) && Arrays.equals(this.longArray, ((StorageTagLongArray)instance).longArray);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.longArray);
    }
}

