/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagDouble;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagEnd;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagFloat;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagInt;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagIntArray;
import simplepets.brainsynder.libs.bslib.nbt.other.IStorageList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagList
extends StorageBase
implements IStorageList<List<StorageBase>> {
    private List<StorageBase> tagList = new ArrayList<StorageBase>();
    private byte tagType = 0;

    @Override
    public List<StorageBase> getList() {
        return this.tagList;
    }

    @Override
    void write(DataOutput output) throws IOException {
        this.tagType = this.tagList.isEmpty() ? (byte)0 : this.tagList.get(0).getId();
        output.writeByte(this.tagType);
        output.writeInt(this.tagList.size());
        for (int i = 0; i < this.tagList.size(); ++i) {
            this.tagList.get(i).write(output);
        }
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(296L);
        if (depth > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.tagType = input.readByte();
        int i = input.readInt();
        if (this.tagType == 0 && i > 0) {
            throw new RuntimeException("Missing type on ListTag");
        }
        sizeTracker.read(32L * (long)i);
        this.tagList = new ArrayList<StorageBase>(i);
        for (int j = 0; j < i; ++j) {
            StorageBase nbtbase = StorageTagList.createNewByType(this.tagType);
            nbtbase.read(input, depth + 1, sizeTracker);
            this.tagList.add(nbtbase);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < this.tagList.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.tagList.get(i));
        }
        return stringbuilder.append(']').toString();
    }

    public List<StorageBase> getTagList() {
        return this.tagList;
    }

    public StorageTagList appendTag(StorageBase nbt) {
        if (nbt.getId() == 0) {
            throw new RuntimeException("Invalid TagEnd added to ListTag");
        }
        if (this.tagType == 0) {
            this.tagType = nbt.getId();
        } else if (this.tagType != nbt.getId()) {
            throw new RuntimeException("Mismatching tag types to tag list (" + nbt.getClass().getSimpleName() + " != " + StorageBase.createNewByType(this.tagType).getClass().getSimpleName() + ")");
        }
        this.tagList.add(nbt);
        return this;
    }

    public void set(int idx, StorageBase nbt) {
        if (nbt.getId() == 0) {
            throw new RuntimeException("Invalid TagEnd added to ListTag");
        }
        if (idx >= 0 && idx < this.tagList.size()) {
            if (this.tagType == 0) {
                this.tagType = nbt.getId();
            } else if (this.tagType != nbt.getId()) {
                throw new RuntimeException("Mismatching tag types to tag list (" + nbt.getClass().getSimpleName() + " != " + StorageBase.createNewByType(this.tagType).getClass().getSimpleName() + ")");
            }
        } else {
            throw new RuntimeException("index out of bounds to set tag in tag list");
        }
        this.tagList.set(idx, nbt);
    }

    public StorageBase removeTag(int i) {
        return this.tagList.remove(i);
    }

    @Override
    public boolean hasNoTags() {
        return this.tagList.isEmpty();
    }

    public StorageTagCompound getCompoundTagAt(int i) {
        StorageBase nbtbase;
        if (i >= 0 && i < this.tagList.size() && (nbtbase = this.tagList.get(i)).getId() == 10) {
            return (StorageTagCompound)nbtbase;
        }
        return new StorageTagCompound();
    }

    public int getIntAt(int i) {
        StorageBase nbtbase;
        if (i >= 0 && i < this.tagList.size() && (nbtbase = this.tagList.get(i)).getId() == 3) {
            return ((StorageTagInt)nbtbase).getInt();
        }
        return 0;
    }

    public int[] getIntArrayAt(int i) {
        StorageBase nbtbase;
        if (i >= 0 && i < this.tagList.size() && (nbtbase = this.tagList.get(i)).getId() == 11) {
            return ((StorageTagIntArray)nbtbase).getIntArray();
        }
        return new int[0];
    }

    public double getDoubleAt(int i) {
        StorageBase nbtbase;
        if (i >= 0 && i < this.tagList.size() && (nbtbase = this.tagList.get(i)).getId() == 6) {
            return ((StorageTagDouble)nbtbase).getDouble();
        }
        return 0.0;
    }

    public float getFloatAt(int i) {
        StorageBase nbtbase;
        if (i >= 0 && i < this.tagList.size() && (nbtbase = this.tagList.get(i)).getId() == 5) {
            return ((StorageTagFloat)nbtbase).getFloat();
        }
        return 0.0f;
    }

    public String getStringTagAt(int i) {
        if (i >= 0 && i < this.tagList.size()) {
            StorageBase nbtbase = this.tagList.get(i);
            return nbtbase.getId() == 8 ? nbtbase.getString() : nbtbase.toString();
        }
        return "";
    }

    public StorageBase get(int idx) {
        return idx >= 0 && idx < this.tagList.size() ? this.tagList.get(idx) : new StorageTagEnd();
    }

    public int tagCount() {
        return this.tagList.size();
    }

    @Override
    public StorageTagList copy() {
        StorageTagList nbttaglist = new StorageTagList();
        nbttaglist.tagType = this.tagType;
        for (StorageBase nbtbase : this.tagList) {
            StorageBase nbtbase1 = nbtbase.copy();
            nbttaglist.tagList.add(nbtbase1);
        }
        return nbttaglist;
    }

    @Override
    public boolean equals(Object instance) {
        if (!super.equals(instance)) {
            return false;
        }
        StorageTagList nbttaglist = (StorageTagList)instance;
        return this.tagType == nbttaglist.tagType && Objects.equals(this.tagList, nbttaglist.tagList);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.tagList.hashCode();
    }

    public int getTagType() {
        return this.tagType;
    }
}

